/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    @Nullable
    private static ItemStack itemLeftInHandAfterPlayerBucketEmptyEvent = null;
    public final Fluid content;

    public BucketItem(Fluid fluid, Item.Properties settings) {
        super(settings);
        this.content = fluid;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        BlockHitResult movingobjectpositionblock = BucketItem.getPlayerPOVHitResult(world, user, this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if (movingobjectpositionblock.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass(itemstack);
        }
        if (movingobjectpositionblock.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass(itemstack);
        }
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        Direction enumdirection = movingobjectpositionblock.getDirection();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        if (world.mayInteract(user, blockposition) && user.mayUseItemAt(blockposition1, enumdirection, itemstack)) {
            BlockPos blockposition2;
            if (this.content == Fluids.EMPTY) {
                BlockState iblockdata = world.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup ifluidsource = (BucketPickup)((Object)block);
                    ItemStack dummyFluid = ifluidsource.pickupBlock(user, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (dummyFluid.isEmpty()) {
                        return InteractionResultHolder.fail(itemstack);
                    }
                    PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((ServerLevel)world, user, blockposition, blockposition, movingobjectpositionblock.getDirection(), itemstack, dummyFluid.getItem(), hand);
                    if (event.isCancelled()) {
                        ((ServerPlayer)user).getBukkitEntity().updateInventory();
                        return InteractionResultHolder.fail(itemstack);
                    }
                    ItemStack itemstack1 = ifluidsource.pickupBlock(user, world, blockposition, iblockdata);
                    if (!itemstack1.isEmpty()) {
                        user.awardStat(Stats.ITEM_USED.get(this));
                        ifluidsource.getPickupSound().ifPresent(soundeffect -> user.playSound((SoundEvent)soundeffect, 1.0f, 1.0f));
                        world.gameEvent((Entity)user, GameEvent.FLUID_PICKUP, blockposition);
                        ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, user, CraftItemStack.asNMSCopy(event.getItemStack()));
                        if (!world.isClientSide) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)user, itemstack1);
                        }
                        return InteractionResultHolder.sidedSuccess(itemstack2, world.isClientSide());
                    }
                }
                return InteractionResultHolder.fail(itemstack);
            }
            BlockState iblockdata = world.getBlockState(blockposition);
            BlockPos blockPos = blockposition2 = iblockdata.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? blockposition : blockposition1;
            if (this.emptyContents(user, world, blockposition2, movingobjectpositionblock, movingobjectpositionblock.getDirection(), blockposition, itemstack, hand)) {
                this.checkExtraContent(user, world, itemstack, blockposition2);
                if (user instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)user, blockposition2, itemstack);
                }
                user.awardStat(Stats.ITEM_USED.get(this));
                return InteractionResultHolder.sidedSuccess(BucketItem.getEmptySuccessItem(itemstack, user), world.isClientSide());
            }
            return InteractionResultHolder.fail(itemstack);
        }
        return InteractionResultHolder.fail(itemstack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        if (itemLeftInHandAfterPlayerBucketEmptyEvent != null) {
            ItemStack itemInHand = itemLeftInHandAfterPlayerBucketEmptyEvent;
            itemLeftInHandAfterPlayerBucketEmptyEvent = null;
            return itemInHand;
        }
        return !player.hasInfiniteMaterials() ? new ItemStack(Items.BUCKET) : stack;
    }

    @Override
    public void checkExtraContent(@Nullable Player player, Level world, ItemStack stack, BlockPos pos) {
    }

    @Override
    public boolean emptyContents(@Nullable Player player, Level world, BlockPos pos, @Nullable BlockHitResult hitResult) {
        return this.emptyContents(player, world, pos, hitResult, null, null, null, InteractionHand.MAIN_HAND);
    }

    public boolean emptyContents(Player entityhuman, Level world, BlockPos blockposition, @Nullable BlockHitResult movingobjectpositionblock, Direction enumdirection, BlockPos clicked, ItemStack itemstack, InteractionHand enumhand) {
        LiquidBlockContainer ifluidcontainer;
        Fluid fluidtype = this.content;
        if (!(fluidtype instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid fluidtypeflowing = (FlowingFluid)fluidtype;
        BlockState iblockdata = world.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        boolean flag = iblockdata.canBeReplaced(this.content);
        boolean flag1 = iblockdata.isAir() || flag || block instanceof LiquidBlockContainer && (ifluidcontainer = (LiquidBlockContainer)((Object)block)).canPlaceLiquid(entityhuman, world, blockposition, iblockdata, this.content);
        boolean flag2 = flag1;
        if (flag2 && entityhuman != null) {
            PlayerBucketEmptyEvent event = CraftEventFactory.callPlayerBucketEmptyEvent((ServerLevel)world, entityhuman, blockposition, clicked, enumdirection, itemstack, enumhand);
            if (event.isCancelled()) {
                ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                return false;
            }
            Object object = event.getItemStack() != null ? (event.getItemStack().equals((Object)CraftItemStack.asNewCraftStack(Items.BUCKET)) ? null : CraftItemStack.asNMSCopy(event.getItemStack())) : (itemLeftInHandAfterPlayerBucketEmptyEvent = ItemStack.EMPTY);
        }
        if (!flag2) {
            return movingobjectpositionblock != null && this.emptyContents(entityhuman, world, movingobjectpositionblock.getBlockPos().relative(movingobjectpositionblock.getDirection()), null, enumdirection, clicked, itemstack, enumhand);
        }
        if (world.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int i = blockposition.getX();
            int j = blockposition.getY();
            int k = blockposition.getZ();
            world.playSound(entityhuman, blockposition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.addParticle(ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer) {
            ifluidcontainer = (LiquidBlockContainer)((Object)block);
            if (this.content == Fluids.WATER) {
                ifluidcontainer.placeLiquid(world, blockposition, iblockdata, fluidtypeflowing.getSource(false));
                this.playEmptySound(entityhuman, world, blockposition);
                return true;
            }
        }
        if (!world.isClientSide && flag && !iblockdata.liquid()) {
            world.destroyBlock(blockposition, true);
        }
        if (!world.setBlock(blockposition, this.content.defaultFluidState().createLegacyBlock(), 11) && !iblockdata.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(entityhuman, world, blockposition);
        return true;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor world, BlockPos pos) {
        SoundEvent soundeffect = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        world.playSound(player, pos, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.gameEvent((Entity)player, GameEvent.FLUID_PLACE, pos);
    }
}

