/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockposition;
        Level world = context.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = context.getClickedPos());
        if (iblockdata.is(Blocks.END_PORTAL_FRAME) && !iblockdata.getValue(EndPortalFrameBlock.HAS_EYE).booleanValue()) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(EndPortalFrameBlock.HAS_EYE, true);
            if (!CraftEventFactory.callEntityChangeBlockEvent(context.getPlayer(), blockposition, iblockdata1)) {
                return InteractionResult.PASS;
            }
            Block.pushEntitiesUp(iblockdata, iblockdata1, world, blockposition);
            world.setBlock(blockposition, iblockdata1, 2);
            world.updateNeighbourForOutputSignal(blockposition, Blocks.END_PORTAL_FRAME);
            context.getItemInHand().shrink(1);
            world.levelEvent(1503, blockposition, 0);
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection = EndPortalFrameBlock.getOrCreatePortalShape().find(world, blockposition);
            if (shapedetector_shapedetectorcollection != null) {
                BlockPos blockposition1 = shapedetector_shapedetectorcollection.getFrontTopLeft().offset(-3, 0, -3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        world.setBlock(blockposition1.offset(i, 0, j), Blocks.END_PORTAL.defaultBlockState(), 2);
                    }
                }
                int viewDistance = world.getCraftServer().getViewDistance() * 16;
                BlockPos soundPos = blockposition1.offset(1, 0, 1);
                for (ServerPlayer player : world.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = (double)soundPos.getX() - player.getX();
                    double deltaZ = (double)soundPos.getZ() - player.getZ();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    double soundRadiusSquared = world.getGlobalSoundRangeSquared(config -> config.endPortalSoundRadius);
                    if (!world.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                        player.connection.send(new ClientboundLevelEventPacket(1038, new BlockPos((int)relativeX, soundPos.getY(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.connection.send(new ClientboundLevelEventPacket(1038, soundPos, 0, true));
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return 0;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ServerLevel worldserver;
        BlockPos blockposition;
        ItemStack itemstack = user.getItemInHand(hand);
        BlockHitResult movingobjectpositionblock = EnderEyeItem.getPlayerPOVHitResult(world, user, ClipContext.Fluid.NONE);
        if (movingobjectpositionblock.getType() == HitResult.Type.BLOCK && world.getBlockState(movingobjectpositionblock.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResultHolder.pass(itemstack);
        }
        user.startUsingItem(hand);
        if (world instanceof ServerLevel && (blockposition = (worldserver = (ServerLevel)world).findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, user.blockPosition(), 100, false)) != null) {
            EyeOfEnder entityendersignal = new EyeOfEnder(world, user.getX(), user.getY(0.5), user.getZ());
            entityendersignal.setItem(itemstack);
            entityendersignal.signalTo(blockposition);
            world.gameEvent(GameEvent.PROJECTILE_SHOOT, entityendersignal.position(), GameEvent.Context.of(user));
            if (!world.addFreshEntity(entityendersignal)) {
                return new InteractionResultHolder<ItemStack>(InteractionResult.FAIL, itemstack);
            }
            if (user instanceof ServerPlayer) {
                CriteriaTriggers.USED_ENDER_EYE.trigger((ServerPlayer)user, blockposition);
            }
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            world.levelEvent(null, 1003, user.blockPosition(), 0);
            itemstack.consume(1, user);
            user.awardStat(Stats.ITEM_USED.get(this));
            user.swing(hand, true);
            return InteractionResultHolder.success(itemstack);
        }
        return InteractionResultHolder.consume(itemstack);
    }
}

