/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.util.Vector;

public class MinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        @Override
        public ItemStack execute(BlockSource pointer, ItemStack stack) {
            double d3;
            RailShape blockpropertytrackposition;
            Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
            ServerLevel worldserver = pointer.level();
            Vec3 vec3d = pointer.center();
            double d0 = vec3d.x() + (double)enumdirection.getStepX() * 1.125;
            double d1 = Math.floor(vec3d.y()) + (double)enumdirection.getStepY();
            double d2 = vec3d.z() + (double)enumdirection.getStepZ() * 1.125;
            BlockPos blockposition = pointer.pos().relative(enumdirection);
            BlockState iblockdata = worldserver.getBlockState(blockposition);
            RailShape railShape = blockpropertytrackposition = iblockdata.getBlock() instanceof BaseRailBlock ? iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if (iblockdata.is(BlockTags.RAILS)) {
                d3 = blockpropertytrackposition.isAscending() ? 0.6 : 0.1;
            } else {
                if (!iblockdata.isAir() || !worldserver.getBlockState(blockposition.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(pointer, stack);
                }
                BlockState iblockdata1 = worldserver.getBlockState(blockposition.below());
                RailShape blockpropertytrackposition1 = iblockdata1.getBlock() instanceof BaseRailBlock ? iblockdata1.getValue(((BaseRailBlock)iblockdata1.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                d3 = enumdirection != Direction.DOWN && blockpropertytrackposition1.isAscending() ? -0.4 : -0.9;
            }
            ItemStack itemstack1 = stack.copyWithCount(1);
            CraftBlock block2 = CraftBlock.at(worldserver, pointer.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
            BlockDispenseEvent event = new BlockDispenseEvent((Block)block2, (org.bukkit.inventory.ItemStack)craftItem.clone(), new Vector(d0, d1 + d3, d2));
            if (!DispenserBlock.eventFired) {
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return stack;
            }
            boolean shrink = true;
            if (!event.getItem().equals((Object)craftItem)) {
                shrink = false;
                ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
            }
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            AbstractMinecart entityminecartabstract = AbstractMinecart.createMinecart(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), ((MinecartItem)itemstack1.getItem()).type, itemstack1, null);
            if (worldserver.addFreshEntity(entityminecartabstract) && shrink) {
                stack.shrink(1);
            }
            return stack;
        }

        @Override
        protected void playSound(BlockSource pointer) {
            pointer.level().levelEvent(1000, pointer.pos(), 0);
        }
    };
    final AbstractMinecart.Type type;

    public MinecartItem(AbstractMinecart.Type type, Item.Properties settings) {
        super(settings);
        this.type = type;
        DispenserBlock.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockposition;
        Level world = context.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = context.getClickedPos());
        if (!iblockdata.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (world instanceof ServerLevel) {
            AbstractMinecart entityminecartabstract;
            ServerLevel worldserver = (ServerLevel)world;
            RailShape blockpropertytrackposition = iblockdata.getBlock() instanceof BaseRailBlock ? iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (blockpropertytrackposition.isAscending()) {
                d0 = 0.5;
            }
            if (CraftEventFactory.callEntityPlaceEvent(context, entityminecartabstract = AbstractMinecart.createMinecart(worldserver, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.0625 + d0, (double)blockposition.getZ() + 0.5, this.type, itemstack, context.getPlayer())).isCancelled()) {
                if (context.getPlayer() != null) {
                    context.getPlayer().containerMenu.sendAllDataToRemote();
                }
                return InteractionResult.FAIL;
            }
            if (!worldserver.addFreshEntity(entityminecartabstract)) {
                return InteractionResult.PASS;
            }
            worldserver.gameEvent(GameEvent.ENTITY_PLACE, blockposition, GameEvent.Context.of(context.getPlayer(), worldserver.getBlockState(blockposition.below())));
        }
        itemstack.shrink(1);
        return InteractionResult.sidedSuccess(world.isClientSide);
    }
}

