/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.leavesmc.leaves.LeavesConfig;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties settings) {
        super(settings);
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), 15.0f), Tool.Rule.overrideSpeed(BlockTags.LEAVES, 15.0f), Tool.Rule.overrideSpeed(BlockTags.WOOL, 5.0f), Tool.Rule.overrideSpeed(List.of(Blocks.VINE, Blocks.GLOW_LICHEN), 2.0f)), 1.0f, 1);
    }

    @Override
    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!world.isClientSide && !state.is(BlockTags.FIRE)) {
            stack.hurtAndBreak(1, miner, EquipmentSlot.MAINHAND);
        }
        return state.is(BlockTags.LEAVES) || state.is(Blocks.COBWEB) || state.is(Blocks.SHORT_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.DEAD_BUSH) || state.is(Blocks.HANGING_ROOTS) || state.is(Blocks.VINE) || state.is(Blocks.TRIPWIRE) || state.is(BlockTags.WOOL);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        GrowingPlantHeadBlock growingPlantHeadBlock;
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        Block block = blockState.getBlock();
        if (block instanceof GrowingPlantHeadBlock && !(growingPlantHeadBlock = (GrowingPlantHeadBlock)block).isMaxAge(blockState)) {
            Player player = context.getPlayer();
            ItemStack itemStack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
            }
            level.playSound(player, blockPos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState blockState2 = growingPlantHeadBlock.getMaxAgeState(blockState);
            level.setBlockAndUpdate(blockPos, blockState2);
            level.gameEvent(GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of(context.getPlayer(), blockState2));
            if (player != null) {
                itemStack.hurtAndBreak(1, player, LivingEntity.getSlotForHand(context.getHand()));
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        Block block2 = blockState.getBlock();
        if (LeavesConfig.redstoneShearsWrench && block2 instanceof ObserverBlock || block2 instanceof DispenserBlock || block2 instanceof PistonBaseBlock || block2 instanceof HopperBlock || block2 instanceof RepeaterBlock || block2 instanceof ComparatorBlock) {
            StateDefinition<Block, BlockState> blockstatelist = block2.getStateDefinition();
            Property<?> iblockstate = blockstatelist.getProperty("facing");
            Player player = context.getPlayer();
            if (iblockstate == null || player == null) {
                return InteractionResult.FAIL;
            }
            if (block2 instanceof PistonBaseBlock && ShearsItem.getNameHelper(blockState, blockstatelist.getProperty("extended")).equals("true")) {
                return InteractionResult.FAIL;
            }
            if (block2 instanceof RepeaterBlock || block2 instanceof ComparatorBlock) {
                if (ShearsItem.getNameHelper(blockState, blockstatelist.getProperty("powered")).equals("true")) {
                    return InteractionResult.FAIL;
                }
                if (block2 instanceof RepeaterBlock && ShearsItem.getNameHelper(blockState, blockstatelist.getProperty("locked")).equals("true")) {
                    return InteractionResult.FAIL;
                }
            }
            BlockState iblockdata1 = ShearsItem.cycleState(blockState, iblockstate, player.isSecondaryUseActive());
            level.setBlock(blockPos, iblockdata1, 18);
            ShearsItem.message(player, Component.translatable("item.minecraft.debug_stick.update", iblockstate.getName(), ShearsItem.getNameHelper(iblockdata1, iblockstate)));
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    private static <T extends Comparable<T>> BlockState cycleState(BlockState state, Property<T> property, boolean inverse) {
        return (BlockState)state.setValue(property, (Comparable)ShearsItem.getRelative(property.getPossibleValues(), state.getValue(property), inverse));
    }

    private static <T> T getRelative(Iterable<T> elements, @Nullable T current, boolean inverse) {
        return inverse ? Util.findPreviousInIterable(elements, current) : Util.findNextInIterable(elements, current);
    }

    private static void message(Player player, Component message) {
        ((ServerPlayer)player).sendSystemMessage(message, true);
    }

    private static <T extends Comparable<T>> String getNameHelper(BlockState state, Property<T> property) {
        return property.getName(state.getValue(property));
    }
}

