/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SpyglassItem
extends Item {
    public static final int USE_DURATION = 1200;
    public static final float ZOOM_FOV_MODIFIER = 0.1f;

    public SpyglassItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public int getUseDuration(ItemStack stack) {
        return 1200;
    }

    @Override
    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    @Override
    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
        user.awardStat(Stats.ITEM_USED.get(this));
        return ItemUtils.startUsingInstantly(world, user, hand);
    }

    @Override
    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        this.stopUsing(user);
        return stack;
    }

    @Override
    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.stopUsing(user);
    }

    private void stopUsing(LivingEntity user) {
        user.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
    }
}

