/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class WindChargeItem
extends Item
implements ProjectileItem {
    private static final int COOLDOWN = 10;

    public WindChargeItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide()) {
            Vec3 vec3 = user.getEyePosition().add(user.getForward().scale(0.8f));
            if (!world.getBlockState(BlockPos.containing(vec3)).canBeReplaced()) {
                vec3 = user.getEyePosition().add(user.getForward().scale(0.05f));
            }
            WindCharge windCharge = new WindCharge(user, world, vec3.x(), vec3.y(), vec3.z());
            windCharge.shootFromRotation(user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity(windCharge);
        }
        world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack itemStack = user.getItemInHand(hand);
        user.getCooldowns().addCooldown(this, 10);
        user.awardStat(Stats.ITEM_USED.get(this));
        itemStack.consume(1, user);
        return InteractionResultHolder.sidedSuccess(itemStack, world.isClientSide());
    }

    @Override
    @Override
    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        RandomSource randomSource = world.getRandom();
        double d = randomSource.triangle(direction.getStepX(), 0.11485000000000001);
        double e = randomSource.triangle(direction.getStepY(), 0.11485000000000001);
        double f = randomSource.triangle(direction.getStepZ(), 0.11485000000000001);
        return new WindCharge(world, pos.x(), pos.y(), pos.z(), d, e, f);
    }

    @Override
    @Override
    public void shoot(Projectile entity, double x, double y, double z, float power, float uncertainty) {
    }

    @Override
    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((pointer, facing) -> DispenserBlock.getDispensePosition(pointer, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).build();
    }
}

