/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.BreachEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static int getItemEnchantmentLevel(Enchantment enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantments = stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return itemEnchantments.getLevel(enchantment);
    }

    public static ItemEnchantments updateEnchantments(ItemStack stack, Consumer<ItemEnchantments.Mutable> applier) {
        DataComponentType<ItemEnchantments> dataComponentType = EnchantmentHelper.getComponentType(stack);
        ItemEnchantments itemEnchantments = stack.get(dataComponentType);
        if (itemEnchantments == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        applier.accept(mutable);
        ItemEnchantments itemEnchantments2 = mutable.toImmutable();
        stack.set(dataComponentType, itemEnchantments2);
        return itemEnchantments2;
    }

    public static boolean canStoreEnchantments(ItemStack stack) {
        return stack.has(EnchantmentHelper.getComponentType(stack));
    }

    public static void setEnchantments(ItemStack stack, ItemEnchantments enchantments) {
        stack.set(EnchantmentHelper.getComponentType(stack), enchantments);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack stack) {
        return stack.getOrDefault(EnchantmentHelper.getComponentType(stack), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack stack) {
        return stack.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack stack) {
        return !stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static float getSweepingDamageRatio(int level) {
        return 1.0f - 1.0f / (float)(level + 1);
    }

    private static void runIterationOnItem(EnchantmentVisitor consumer, ItemStack stack) {
        ItemEnchantments itemEnchantments = stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
            consumer.accept((Enchantment)((Holder)entry.getKey()).value(), entry.getIntValue());
        }
    }

    private static void runIterationOnInventory(EnchantmentVisitor consumer, Iterable<ItemStack> stacks) {
        for (ItemStack itemStack : stacks) {
            EnchantmentHelper.runIterationOnItem(consumer, itemStack);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> equipment, DamageSource source) {
        MutableInt mutableInt = new MutableInt();
        EnchantmentHelper.runIterationOnInventory((enchantment, level) -> mutableInt.add(enchantment.getDamageProtection(level, source)), equipment);
        return mutableInt.intValue();
    }

    public static float getDamageBonus(ItemStack stack, @Nullable EntityType<?> entityType) {
        MutableFloat mutableFloat = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((enchantment, level) -> mutableFloat.add(enchantment.getDamageBonus(level, entityType)), stack);
        return mutableFloat.floatValue();
    }

    public static float getSweepingDamageRatio(LivingEntity entity) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, entity);
        if (i > 0) {
            return EnchantmentHelper.getSweepingDamageRatio(i);
        }
        return 0.0f;
    }

    public static float calculateArmorBreach(@Nullable Entity entity, float f) {
        LivingEntity livingEntity;
        int i;
        if (entity instanceof LivingEntity && (i = EnchantmentHelper.getEnchantmentLevel(Enchantments.BREACH, livingEntity = (LivingEntity)entity)) > 0) {
            return BreachEnchantment.calculateArmorBreach(i, f);
        }
        return f;
    }

    public static void doPostHurtEffects(LivingEntity user, Entity attacker) {
        EnchantmentVisitor enchantmentVisitor = (enchantment, level) -> enchantment.doPostHurt(user, attacker, level);
        if (user != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmentVisitor, user.getAllSlots());
        }
        if (attacker instanceof Player) {
            EnchantmentHelper.runIterationOnItem(enchantmentVisitor, user.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(LivingEntity user, Entity target) {
        EnchantmentVisitor enchantmentVisitor = (enchantment, level) -> enchantment.doPostAttack(user, target, level);
        if (user != null) {
            EnchantmentHelper.runIterationOnInventory(enchantmentVisitor, user.getAllSlots());
        }
        if (user instanceof Player) {
            EnchantmentHelper.runIterationOnItem(enchantmentVisitor, user.getMainHandItem());
        }
    }

    public static void doPostItemStackHurtEffects(LivingEntity attacker, Entity target, ItemEnchantments enchantments) {
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : enchantments.entrySet()) {
            ((Enchantment)((Holder)entry.getKey()).value()).doPostItemStackHurt(attacker, target, entry.getIntValue());
        }
    }

    public static int getEnchantmentLevel(Enchantment enchantment, LivingEntity entity) {
        Collection<ItemStack> iterable = enchantment.getSlotItems(entity).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemStack : iterable) {
            int j = EnchantmentHelper.getItemEnchantmentLevel(enchantment, itemStack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static float getSneakingSpeedBonus(LivingEntity entity) {
        return (float)EnchantmentHelper.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, entity) * 0.15f;
    }

    public static int getKnockbackBonus(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.KNOCKBACK, entity);
    }

    public static int getFireAspect(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_ASPECT, entity);
    }

    public static int getRespiration(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.RESPIRATION, entity);
    }

    public static int getDepthStrider(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, entity);
    }

    public static int getBlockEfficiency(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.EFFICIENCY, entity);
    }

    public static int getFishingLuckBonus(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LUCK_OF_THE_SEA, stack);
    }

    public static int getFishingSpeedBonus(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LURE, stack);
    }

    public static int getMobLooting(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.LOOTING, entity);
    }

    public static boolean hasAquaAffinity(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, entity) > 0;
    }

    public static boolean hasFrostWalker(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, entity) > 0;
    }

    public static boolean hasSoulSpeed(LivingEntity entity) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, entity) > 0;
    }

    public static boolean hasBindingCurse(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, stack) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, stack) > 0;
    }

    public static boolean hasSilkTouch(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, stack) > 0;
    }

    public static int getLoyalty(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOYALTY, stack);
    }

    public static int getRiptide(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.RIPTIDE, stack);
    }

    public static boolean hasChanneling(ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.CHANNELING, stack) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment enchantment, LivingEntity entity) {
        return EnchantmentHelper.getRandomItemWith(enchantment, entity, stack -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment enchantment, LivingEntity entity, Predicate<ItemStack> condition) {
        Map<EquipmentSlot, ItemStack> map = enchantment.getSlotItems(entity);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemStack = entry.getValue();
            if (itemStack.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel(enchantment, itemStack) <= 0 || !condition.test(itemStack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(entity.getRandom().nextInt(list.size()));
    }

    public static int getEnchantmentCost(RandomSource random, int slotIndex, int bookshelfCount, ItemStack stack) {
        Item item = stack.getItem();
        int i = item.getEnchantmentValue();
        if (i <= 0) {
            return 0;
        }
        if (bookshelfCount > 15) {
            bookshelfCount = 15;
        }
        int j = random.nextInt(8) + 1 + (bookshelfCount >> 1) + random.nextInt(bookshelfCount + 1);
        if (slotIndex == 0) {
            return Math.max(j / 3, 1);
        }
        if (slotIndex == 1) {
            return j * 2 / 3 + 1;
        }
        return Math.max(j, bookshelfCount * 2);
    }

    public static ItemStack enchantItem(FeatureFlagSet enabledFeatures, RandomSource random, ItemStack stack, int level, boolean treasureAllowed) {
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(enabledFeatures, random, stack, level, treasureAllowed);
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance enchantmentInstance : list) {
            stack.enchant(enchantmentInstance.enchantment, enchantmentInstance.level);
        }
        return stack;
    }

    public static List<EnchantmentInstance> selectEnchantment(FeatureFlagSet enabledFeatures, RandomSource random, ItemStack stack, int level, boolean treasureAllowed) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.getItem();
        int i = item.getEnchantmentValue();
        if (i <= 0) {
            return list;
        }
        level += 1 + random.nextInt(i / 4 + 1) + random.nextInt(i / 4 + 1);
        float f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> list2 = EnchantmentHelper.getAvailableEnchantmentResults(enabledFeatures, level = Mth.clamp(Math.round((float)level + (float)level * f), 1, Integer.MAX_VALUE), stack, treasureAllowed);
        if (!list2.isEmpty()) {
            WeightedRandom.getRandomItem(random, list2).ifPresent(list::add);
            while (random.nextInt(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments(list2, (EnchantmentInstance)Util.lastOf(list));
                }
                if (list2.isEmpty()) break;
                WeightedRandom.getRandomItem(random, list2).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> possibleEntries, EnchantmentInstance pickedEntry) {
        Iterator<EnchantmentInstance> iterator = possibleEntries.iterator();
        while (iterator.hasNext()) {
            if (pickedEntry.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> existing, Enchantment candidate) {
        for (Holder<Enchantment> holder : existing) {
            if (holder.value().isCompatibleWith(candidate)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(FeatureFlagSet enabledFeatures, int level, ItemStack stack, boolean treasureAllowed) {
        ArrayList list = Lists.newArrayList();
        boolean bl = stack.is(Items.BOOK);
        block0: for (Enchantment enchantment : BuiltInRegistries.ENCHANTMENT) {
            if (!enchantment.isEnabled(enabledFeatures) || enchantment.isTreasureOnly() && !treasureAllowed || !enchantment.isDiscoverable() || !bl && (!enchantment.canEnchant(stack) || !enchantment.isPrimaryItem(stack))) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (level < enchantment.getMinCost(i) || level > enchantment.getMaxCost(i)) continue;
                list.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

