/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class FrostWalkerEnchantment
extends Enchantment {
    public FrostWalkerEnchantment(Enchantment.EnchantmentDefinition properties) {
        super(properties);
    }

    @Override
    public boolean isTreasureOnly() {
        return true;
    }

    public static void onEntityMoved(LivingEntity entity, Level world, BlockPos blockPos, int level) {
        if (entity.onGround()) {
            BlockState iblockdata = Blocks.FROSTED_ICE.defaultBlockState();
            int j = Math.min(16, 2 + level);
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (BlockPos blockposition1 : BlockPos.betweenClosed(blockPos.offset(-j, -1, -j), blockPos.offset(j, -1, j))) {
                BlockState iblockdata2;
                if (!blockposition1.closerToCenterThan(entity.position(), j)) continue;
                blockposition_mutableblockposition.set(blockposition1.getX(), blockposition1.getY() + 1, blockposition1.getZ());
                BlockState iblockdata1 = world.getBlockState(blockposition_mutableblockposition);
                if (!iblockdata1.isAir() || (iblockdata2 = world.getBlockState(blockposition1)) != FrostedIceBlock.meltsInto() || !iblockdata.canSurvive(world, blockposition1) || !world.isUnobstructed(iblockdata, blockposition1, CollisionContext.empty()) || !CraftEventFactory.handleBlockFormEvent(world, blockposition1, iblockdata, entity)) continue;
                world.scheduleTick(blockposition1, Blocks.FROSTED_ICE, Mth.nextInt(entity.getRandom(), 60, 120));
            }
        }
    }

    @Override
    public boolean checkCompatibility(Enchantment other) {
        return super.checkCompatibility(other) && other != Enchantments.DEPTH_STRIDER;
    }
}

