/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.leavesmc.leaves.LeavesConfig;

public class ProtectionEnchantment
extends Enchantment {
    public final Type type;

    public ProtectionEnchantment(Enchantment.EnchantmentDefinition properties, Type protectionType) {
        super(properties);
        this.type = protectionType;
    }

    @Override
    public int getDamageProtection(int level, DamageSource source) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0;
        }
        if (this.type == Type.ALL) {
            return level;
        }
        if (this.type == Type.FIRE && source.is(DamageTypeTags.IS_FIRE)) {
            return level * 2;
        }
        if (this.type == Type.FALL && source.is(DamageTypeTags.IS_FALL)) {
            return level * 3;
        }
        if (this.type == Type.EXPLOSION && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return level * 2;
        }
        return this.type == Type.PROJECTILE && source.is(DamageTypeTags.IS_PROJECTILE) ? level * 2 : 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment other) {
        boolean bl;
        if (LeavesConfig.protectionStacking) {
            return super.checkCompatibility(other);
        }
        if (other instanceof ProtectionEnchantment) {
            ProtectionEnchantment protectionEnchantment = (ProtectionEnchantment)other;
            bl = this.type != protectionEnchantment.type && (this.type == Type.FALL || protectionEnchantment.type == Type.FALL);
        } else {
            bl = super.checkCompatibility(other);
        }
        return bl;
    }

    public static int getFireAfterDampener(LivingEntity entity, int duration) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, entity);
        if (i > 0) {
            duration -= Mth.floor((float)duration * (float)i * 0.15f);
        }
        return duration;
    }

    public static double getExplosionKnockbackAfterDampener(LivingEntity entity, double velocity) {
        int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, entity);
        if (i > 0) {
            velocity *= Mth.clamp(1.0 - (double)i * 0.15, 0.0, 1.0);
        }
        return velocity;
    }

    public static enum Type {
        ALL,
        FIRE,
        FALL,
        EXPLOSION,
        PROJECTILE;

    }
}

