/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ThornsEnchantment
extends Enchantment {
    private static final float CHANCE_PER_LEVEL = 0.15f;

    public ThornsEnchantment(Enchantment.EnchantmentDefinition properties) {
        super(properties);
    }

    @Override
    @Override
    public void doPostHurt(LivingEntity user, Entity attacker, int level) {
        RandomSource randomSource = user.getRandom();
        Map.Entry<EquipmentSlot, ItemStack> entry = EnchantmentHelper.getRandomItemWith(Enchantments.THORNS, user);
        if (ThornsEnchantment.shouldHit(level, randomSource)) {
            if (attacker != null) {
                attacker.hurt(user.damageSources().thorns(user), ThornsEnchantment.getDamage(level, randomSource));
            }
            if (entry != null) {
                entry.getValue().hurtAndBreak(2, user, entry.getKey());
            }
        }
    }

    public static boolean shouldHit(int level, RandomSource random) {
        if (level <= 0) {
            return false;
        }
        return random.nextFloat() < 0.15f * (float)level;
    }

    public static int getDamage(int level, RandomSource random) {
        if (level > 10) {
            return level - 10;
        }
        return 1 + random.nextInt(4);
    }
}

