/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;

public interface BlockGetter
extends LevelHeightAccessor {
    @Nullable
    public BlockEntity getBlockEntity(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos pos, BlockEntityType<T> type) {
        BlockEntity tileentity = this.getBlockEntity(pos);
        return tileentity != null && tileentity.getType() == type ? Optional.of(tileentity) : Optional.empty();
    }

    public BlockState getBlockState(BlockPos var1);

    @Nullable
    public BlockState getBlockStateIfLoaded(BlockPos var1);

    @Nullable
    default public Block getBlockIfLoaded(BlockPos blockposition) {
        BlockState type = this.getBlockStateIfLoaded(blockposition);
        return type == null ? null : type.getBlock();
    }

    @Nullable
    public FluidState getFluidIfLoaded(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    default public int getLightEmission(BlockPos pos) {
        return this.getBlockState(pos).getLightEmission();
    }

    default public int getMaxLightLevel() {
        return 15;
    }

    default public Stream<BlockState> getBlockStates(AABB box) {
        return BlockPos.betweenClosedStream(box).map(this::getBlockState);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext context) {
        return BlockGetter.traverseBlocks(context.getFrom(), context.getTo(), context, (clipblockstatecontext1, blockposition) -> {
            BlockState iblockdata = this.getBlockState((BlockPos)blockposition);
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return clipblockstatecontext1.isTargetBlock().test(iblockdata) ? new BlockHitResult(clipblockstatecontext1.getTo(), Direction.getNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return BlockHitResult.miss(clipblockstatecontext1.getTo(), Direction.getNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()));
        });
    }

    @Nullable
    default public HitResult.Type clipDirect(Vec3 start, Vec3 end, BlockPos pos, BlockState state, CollisionContext collisionContext) {
        if (state.isAir()) {
            return null;
        }
        VoxelShape voxelshape = ClipContext.Block.COLLIDER.get(state, this, pos, collisionContext);
        BlockHitResult hitResult = this.clipWithInteractionOverride(start, end, pos, voxelshape, state);
        return hitResult == null ? null : hitResult.getType();
    }

    default public BlockHitResult clip(ClipContext raytrace1, BlockPos blockposition) {
        return this.clip(raytrace1, blockposition, null);
    }

    default public BlockHitResult clip(ClipContext raytrace1, BlockPos blockposition, Predicate<? super org.bukkit.block.Block> canCollide) {
        LevelAccessor levelAccessor;
        BlockGetter blockGetter;
        BlockState iblockdata = this.getBlockStateIfLoaded(blockposition);
        if (iblockdata == null) {
            Vec3 vec3d = raytrace1.getFrom().subtract(raytrace1.getTo());
            return BlockHitResult.miss(raytrace1.getTo(), Direction.getNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(raytrace1.getTo()));
        }
        if (iblockdata.isAir() || canCollide != null && (blockGetter = this) instanceof LevelAccessor && !canCollide.test(CraftBlock.at(levelAccessor = (LevelAccessor)blockGetter, blockposition))) {
            return null;
        }
        FluidState fluid = iblockdata.getFluidState();
        Vec3 vec3d = raytrace1.getFrom();
        Vec3 vec3d1 = raytrace1.getTo();
        VoxelShape voxelshape = raytrace1.getBlockShape(iblockdata, this, blockposition);
        BlockHitResult movingobjectpositionblock = this.clipWithInteractionOverride(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.getFluidShape(fluid, this, blockposition);
        BlockHitResult movingobjectpositionblock1 = voxelshape1.clip(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock.getLocation());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock1.getLocation());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public BlockHitResult clip(ClipContext context) {
        return this.clip(context, (Predicate<? super org.bukkit.block.Block>)null);
    }

    default public BlockHitResult clip(ClipContext context, Predicate<? super org.bukkit.block.Block> canCollide) {
        return BlockGetter.traverseBlocks(context.getFrom(), context.getTo(), context, (raytrace1, blockposition) -> this.clip((ClipContext)raytrace1, (BlockPos)blockposition, canCollide), raytrace1 -> {
            Vec3 vec3d = raytrace1.getFrom().subtract(raytrace1.getTo());
            return BlockHitResult.miss(raytrace1.getTo(), Direction.getNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(raytrace1.getTo()));
        });
    }

    @Nullable
    default public BlockHitResult clipWithInteractionOverride(Vec3 start, Vec3 end, BlockPos pos, VoxelShape shape, BlockState state) {
        BlockHitResult movingobjectpositionblock1;
        BlockHitResult movingobjectpositionblock = shape.clip(start, end, pos);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = state.getInteractionShape(this, pos).clip(start, end, pos)) != null && movingobjectpositionblock1.getLocation().subtract(start).lengthSqr() < movingobjectpositionblock.getLocation().subtract(start).lengthSqr()) {
            return movingobjectpositionblock.withDirection(movingobjectpositionblock1.getDirection());
        }
        return movingobjectpositionblock;
    }

    default public double getBlockFloorHeight(VoxelShape blockCollisionShape, Supplier<VoxelShape> belowBlockCollisionShapeGetter) {
        if (!blockCollisionShape.isEmpty()) {
            return blockCollisionShape.max(Direction.Axis.Y);
        }
        double d0 = belowBlockCollisionShapeGetter.get().max(Direction.Axis.Y);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPos pos) {
        return this.getBlockFloorHeight(this.getBlockState(pos).getCollisionShape(this, pos), () -> {
            BlockPos blockposition1 = pos.below();
            return this.getBlockState(blockposition1).getCollisionShape(this, blockposition1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3 start, Vec3 end, C context, BiFunction<C, BlockPos, T> blockHitFactory, Function<C, T> missFactory) {
        T object;
        int k;
        int j;
        if (start.equals(end)) {
            return missFactory.apply(context);
        }
        double d0 = Mth.lerp(-1.0E-7, end.x, start.x);
        double d1 = Mth.lerp(-1.0E-7, end.y, start.y);
        double d2 = Mth.lerp(-1.0E-7, end.z, start.z);
        double d3 = Mth.lerp(-1.0E-7, start.x, end.x);
        double d4 = Mth.lerp(-1.0E-7, start.y, end.y);
        double d5 = Mth.lerp(-1.0E-7, start.z, end.z);
        int i = Mth.floor(d3);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(i, j = Mth.floor(d4), k = Mth.floor(d5));
        T t0 = blockHitFactory.apply(context, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.sign(d6);
        int i1 = Mth.sign(d7);
        int j1 = Mth.sign(d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.frac(d3) : Mth.frac(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.frac(d4) : Mth.frac(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.frac(d5) : Mth.frac(d5));
        do {
            if (d12 > 1.0 && d13 > 1.0 && d14 > 1.0) {
                return missFactory.apply(context);
            }
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                    continue;
                }
                k += j1;
                d14 += d11;
                continue;
            }
            if (d13 < d14) {
                j += i1;
                d13 += d10;
                continue;
            }
            k += j1;
            d14 += d11;
        } while ((object = blockHitFactory.apply(context, blockposition_mutableblockposition.set(i, j, k))) == null);
        return object;
    }
}

