/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.leavesmc.leaves.LeavesConfig;

public class EntityBasedExplosionDamageCalculator
extends ExplosionDamageCalculator {
    private final Entity source;

    public EntityBasedExplosionDamageCalculator(Entity entity) {
        this.source = entity;
    }

    @Override
    public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        float blastResistance;
        float effectiveExplosionResistance;
        if (!LeavesConfig.removeDamageLambda) {
            return super.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState).map(max -> Float.valueOf(this.source.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState, max.floatValue())));
        }
        Optional<Float> optionalBlastResistance = super.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState);
        if (optionalBlastResistance.isPresent() && (effectiveExplosionResistance = this.source.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState, blastResistance = optionalBlastResistance.get().floatValue())) != blastResistance) {
            return Optional.of(Float.valueOf(effectiveExplosionResistance));
        }
        return optionalBlastResistance;
    }

    @Override
    public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float power) {
        return this.source.shouldBlockExplode(explosion, world, pos, state, power);
    }
}

