/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.papermc.paper.util.CollisionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.HumanEntity;

public interface EntityGetter {
    public List<Entity> getHardCollidingEntities(Entity var1, AABB var2, Predicate<? super Entity> var3);

    public void getEntities(Entity var1, AABB var2, Predicate<? super Entity> var3, List<Entity> var4);

    public void getHardCollidingEntities(Entity var1, AABB var2, Predicate<? super Entity> var3, List<Entity> var4);

    public <T> void getEntitiesByClass(Class<? extends T> var1, Entity var2, AABB var3, List<? super T> var4, Predicate<? super T> var5);

    public List<Entity> getEntities(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB box, Predicate<? super T> predicate) {
        return this.getEntities(EntityTypeTest.forClass(entityClass), box, predicate);
    }

    public List<? extends Player> players();

    default public List<Entity> getEntities(@Nullable Entity except, AABB box) {
        return this.getEntities(except, box, EntitySelector.NO_SPECTATORS);
    }

    default public boolean isUnobstructed(@Nullable Entity except, VoxelShape shape) {
        if (shape.isEmpty()) {
            return false;
        }
        AABB singleAABB = shape.getSingleAABBRepresentation();
        List<Entity> entities = this.getEntities(except, singleAABB == null ? shape.bounds() : singleAABB.inflate(-1.0E-7, -1.0E-7, -1.0E-7));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            AABB entityBB;
            Entity otherEntity = entities.get(i);
            if (otherEntity.isRemoved() || !otherEntity.blocksBuilding || except != null && otherEntity.isPassengerOfSameVehicle(except) || singleAABB == null && (CollisionUtil.isEmpty(entityBB = otherEntity.getBoundingBox()) || !CollisionUtil.voxelShapeIntersectNoEmpty(shape, entityBB))) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB box) {
        return this.getEntitiesOfClass(entityClass, box, EntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, AABB box) {
        if (CollisionUtil.isEmpty(box)) {
            return new ArrayList<VoxelShape>();
        }
        box = box.inflate(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.hardCollides() ? this.getEntities(entity, box, null) : this.getHardCollidingEntities(entity, box, null);
        ArrayList<VoxelShape> ret = new ArrayList<VoxelShape>(Math.min(25, entities.size()));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || (entity != null || !otherEntity.canBeCollidedWith()) && (entity == null || !entity.canCollideWith(otherEntity))) continue;
            ret.add(Shapes.create(otherEntity.getBoundingBox()));
        }
        return ret;
    }

    @Nullable
    default public Player findNearbyPlayer(Entity entity, double maxDistance, @Nullable Predicate<Entity> predicate) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), maxDistance, predicate);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double maxDistance, @Nullable Predicate<Entity> targetPredicate) {
        double d = -1.0;
        Player player = null;
        for (Player player2 : this.players()) {
            if (targetPredicate != null && !targetPredicate.test(player2)) continue;
            double e = player2.distanceToSqr(x, y, z);
            if (!(maxDistance < 0.0) && !(e < maxDistance * maxDistance) || d != -1.0 && !(e < d)) continue;
            d = e;
            player = player2;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x, y, z, radius, notSpectator ? EntitySelector.NO_SPECTATORS : EntitySelector.NO_CREATIVE_OR_SPECTATOR);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Player player : this.players()) {
            if (predicate != null && !predicate.test(player)) continue;
            double distanceSquared = player.distanceToSqr(x, y, z);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)player.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public Player getNearestPlayer(Entity entity, double maxDistance) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), maxDistance, false);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double maxDistance, boolean ignoreCreative) {
        Predicate<Entity> predicate = ignoreCreative ? EntitySelector.NO_CREATIVE_OR_SPECTATOR : EntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(x, y, z, maxDistance, predicate);
    }

    default public boolean hasNearbyAlivePlayerThatAffectsSpawning(double x, double y, double z, double range) {
        for (Player player : this.players()) {
            if (!EntitySelector.PLAYER_AFFECTS_SPAWNING.test(player)) continue;
            double distanceSqr = player.distanceToSqr(x, y, z);
            if (!(range < 0.0) && !(distanceSqr < range * range)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasNearbyAlivePlayer(double x, double y, double z, double range) {
        for (Player player : this.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double d = player.distanceToSqr(x, y, z);
            if (!(range < 0.0) && !(d < range * range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, entity.getX(), entity.getY(), entity.getZ());
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, null, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(Class<? extends T> entityClass, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z, AABB box) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(entityClass, box, entityOfClass -> true), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(List<? extends T> entityList, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z) {
        double d = -1.0;
        LivingEntity livingEntity = null;
        for (LivingEntity livingEntity2 : entityList) {
            double e = livingEntity2.distanceToSqr(x, y, z);
            if (d != -1.0 && !(e < d) || !targetPredicate.test(entity, livingEntity2)) continue;
            d = e;
            livingEntity = livingEntity2;
        }
        return (T)livingEntity;
    }

    default public List<Player> getNearbyPlayers(TargetingConditions targetPredicate, LivingEntity entity, AABB box) {
        ArrayList list = Lists.newArrayList();
        for (Player player : this.players()) {
            if (!box.contains(player.getX(), player.getY(), player.getZ()) || !targetPredicate.test(entity, player)) continue;
            list.add(player);
        }
        return list;
    }

    default public <T extends LivingEntity> List<T> getNearbyEntities(Class<T> entityClass, TargetingConditions targetPredicate, LivingEntity targetingEntity, AABB box) {
        List<LivingEntity> list = this.getEntitiesOfClass(entityClass, box, livingEntityx -> true);
        ArrayList list2 = Lists.newArrayList();
        for (LivingEntity livingEntity : list) {
            if (!targetPredicate.test(targetingEntity, livingEntity)) continue;
            list2.add(livingEntity);
        }
        return list2;
    }

    @Nullable
    default public Player getPlayerByUUID(UUID uuid) {
        for (int i = 0; i < this.players().size(); ++i) {
            Player player = this.players().get(i);
            if (!uuid.equals(player.getUUID())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    default public Player getGlobalPlayerByUUID(UUID uuid) {
        return this.getPlayerByUUID(uuid);
    }
}

