/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import org.leavesmc.leaves.LeavesConfig;

public class LocalMobCapCalculator {
    private final Long2ObjectMap<List<ServerPlayer>> playersNearChunk = new Long2ObjectOpenHashMap();
    private final Map<ServerPlayer, MobCounts> playerMobCounts = Maps.newHashMap();
    private final ChunkMap chunkMap;

    public LocalMobCapCalculator(ChunkMap threadedAnvilChunkStorage) {
        this.chunkMap = threadedAnvilChunkStorage;
    }

    private List<ServerPlayer> getPlayersNear(ChunkPos chunkPos) {
        return (List)this.playersNearChunk.computeIfAbsent(chunkPos.toLong(), pos -> this.chunkMap.getPlayersCloseForSpawning(chunkPos));
    }

    public void addMob(ChunkPos chunkPos, MobCategory spawnGroup) {
        for (ServerPlayer serverPlayer : this.getPlayersNear(chunkPos)) {
            this.playerMobCounts.computeIfAbsent(serverPlayer, player -> new MobCounts()).add(spawnGroup);
        }
    }

    public boolean canSpawn(MobCategory spawnGroup, ChunkPos chunkPos) {
        for (ServerPlayer serverPlayer : this.getPlayersNear(chunkPos)) {
            MobCounts mobCounts = this.playerMobCounts.get(serverPlayer);
            if (mobCounts != null && !mobCounts.canSpawn(spawnGroup)) continue;
            return true;
        }
        return false;
    }

    static class MobCounts {
        private final Object2IntMap<MobCategory> counts = new Object2IntOpenHashMap(MobCategory.values().length);
        public final int[] arrCounts = new int[MobCategory.values().length];

        MobCounts() {
        }

        public void add(MobCategory spawnGroup) {
            if (!LeavesConfig.storeMobCountsInArray) {
                this.counts.computeInt((Object)spawnGroup, (group, density) -> density == null ? 1 : density + 1);
            } else {
                int n = spawnGroup.ordinal();
                this.arrCounts[n] = this.arrCounts[n] + 1;
            }
        }

        public boolean canSpawn(MobCategory spawnGroup) {
            if (!LeavesConfig.storeMobCountsInArray) {
                return this.counts.getOrDefault((Object)spawnGroup, 0) < spawnGroup.getMaxInstancesPerChunk();
            }
            return this.arrCounts[spawnGroup.ordinal()] < spawnGroup.getMaxInstancesPerChunk();
        }
    }
}

