/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.slf4j.Logger;

public final class NaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    public static final MobCategory[] SPAWNING_CATEGORIES = (MobCategory[])Stream.of(MobCategory.values()).filter(enumcreaturetype -> enumcreaturetype != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState createState(int spawningChunkCount, Iterable<Entity> entities, ChunkGetter chunkSource, LocalMobCapCalculator densityCapper) {
        return NaturalSpawner.createState(spawningChunkCount, entities, chunkSource, densityCapper, false);
    }

    public static SpawnState createState(int spawningChunkCount, Iterable<Entity> entities, ChunkGetter chunkSource, LocalMobCapCalculator densityCapper, boolean countMobs) {
        PotentialCalculator spawnercreatureprobabilities = new PotentialCalculator();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : entities) {
            MobCategory enumcreaturetype;
            Mob entityinsentient;
            if (entity instanceof Mob && ((entityinsentient = (Mob)entity).isPersistenceRequired() || entityinsentient.requiresCustomPersistence()) || (enumcreaturetype = entity.getType().getCategory()) == MobCategory.MISC || !LeavesConfig.mcTechnicalMode && !entity.level().paperConfig().entities.spawning.countAllMobsForSpawning && entity.spawnReason != CreatureSpawnEvent.SpawnReason.NATURAL && entity.spawnReason != CreatureSpawnEvent.SpawnReason.CHUNK_GEN) continue;
            BlockPos blockposition = entity.blockPosition();
            chunkSource.query(ChunkPos.asLong(blockposition), chunk -> {
                MobSpawnSettings.MobSpawnCost biomesettingsmobs_b = NaturalSpawner.getRoughBiome(blockposition, chunk).getMobSettings().getMobSpawnCost(entity.getType());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.addCharge(entity.blockPosition(), biomesettingsmobs_b.charge());
                }
                if (densityCapper != null && entity instanceof Mob) {
                    densityCapper.addMob(chunk.getPos(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
                if (countMobs) {
                    chunk.level.getChunkSource().chunkMap.updatePlayerMobTypeMap(entity);
                }
            });
        }
        return new SpawnState(spawningChunkCount, (Object2IntOpenHashMap<MobCategory>)object2intopenhashmap, spawnercreatureprobabilities, densityCapper);
    }

    static Biome getRoughBiome(BlockPos pos, ChunkAccess chunk) {
        return chunk.getNoiseBiome(QuartPos.fromBlock(pos.getX()), QuartPos.fromBlock(pos.getY()), QuartPos.fromBlock(pos.getZ())).value();
    }

    public static void spawnForChunk(ServerLevel world, LevelChunk chunk, SpawnState info, boolean spawnAnimals, boolean spawnMonsters, boolean rareSpawn) {
        NaturalSpawner.spawnForChunk(world, chunk, info, spawnAnimals, spawnMonsters, rareSpawn, false);
    }

    public static void spawnForChunk(ServerLevel world, LevelChunk chunk, SpawnState info, boolean spawnAnimals, boolean spawnMonsters, boolean rareSpawn, boolean peacefulModeSwitch) {
        world.getProfiler().push("spawner");
        MobCategory[] aenumcreaturetype = SPAWNING_CATEGORIES;
        int i = aenumcreaturetype.length;
        LevelData worlddata = world.getLevelData();
        for (int j = 0; j < i; ++j) {
            MobCategory enumcreaturetype = aenumcreaturetype[j];
            if (enumcreaturetype == MobCategory.MONSTER && peacefulModeSwitch) continue;
            boolean spawnThisTick = true;
            int limit = enumcreaturetype.getMaxInstancesPerChunk();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = world.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.getGameTime() % world.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = world.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0) continue;
            int currEntityCount = info.mobCategoryCounts.getInt((Object)enumcreaturetype);
            int k1 = limit * info.getSpawnableChunkCount() / MAGIC_NUMBER;
            int difference = k1 - currEntityCount;
            if (world.paperConfig().entities.spawning.perPlayerMobSpawns) {
                int minDiff = Integer.MAX_VALUE;
                ReferenceList<ServerPlayer> inRange = world.chunkSource.chunkMap.getNearbyPlayers().getPlayers(chunk.getPos(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
                if (inRange != null) {
                    Object[] backingSet = inRange.getRawData();
                    int len = inRange.size();
                    for (int k = 0; k < len; ++k) {
                        minDiff = Math.min(limit - world.getChunkSource().chunkMap.getMobCountNear((ServerPlayer)backingSet[k], enumcreaturetype), minDiff);
                    }
                }
                int n = difference = minDiff == Integer.MAX_VALUE ? 0 : minDiff;
            }
            if (!spawnAnimals && enumcreaturetype.isFriendly() || !spawnMonsters && !enumcreaturetype.isFriendly() || !rareSpawn && enumcreaturetype.isPersistent() || difference <= 0) continue;
            Objects.requireNonNull(info);
            SpawnPredicate spawnercreature_c = info::canSpawn;
            Objects.requireNonNull(info);
            int spawnCount = NaturalSpawner.spawnCategoryForChunk(enumcreaturetype, world, chunk, spawnercreature_c, info::afterSpawn, difference, world.paperConfig().entities.spawning.perPlayerMobSpawns ? world.getChunkSource().chunkMap::updatePlayerMobTypeMap : null);
            info.mobCategoryCounts.mergeInt((Object)enumcreaturetype, spawnCount, Integer::sum);
        }
        world.getProfiler().pop();
    }

    public static int globalLimitForCategory(ServerLevel level, MobCategory category, int spawnableChunkCount) {
        int categoryLimit = level.getWorld().getSpawnLimitUnsafe(CraftSpawnCategory.toBukkit(category));
        if (categoryLimit < 1) {
            return categoryLimit;
        }
        return categoryLimit * spawnableChunkCount / MAGIC_NUMBER;
    }

    public static void spawnCategoryForChunk(MobCategory group, ServerLevel world, LevelChunk chunk, SpawnPredicate checker, AfterSpawnCallback runner) {
        NaturalSpawner.spawnCategoryForChunk(group, world, chunk, checker, runner, Integer.MAX_VALUE, null);
    }

    public static int spawnCategoryForChunk(MobCategory group, ServerLevel world, LevelChunk chunk, SpawnPredicate checker, AfterSpawnCallback runner, int maxSpawns, Consumer<Entity> trackEntity) {
        if (LeavesConfig.ignoreLC) {
            int spawnN = 0;
            for (int i = chunk.getMinBuildHeight(); i < chunk.getMaxBuildHeight(); i += 16) {
                LevelChunkSection section = chunk.getSections()[chunk.getSectionIndex(i)];
                if (section == null || section.hasOnlyAir()) continue;
                BlockPos pos = NaturalSpawner.getRandomPosInChunk(world, chunk).offset(0, i, 0);
                spawnN += NaturalSpawner.spawnCategoryForPosition(group, world, chunk, pos, checker, runner, maxSpawns, trackEntity);
            }
            return spawnN;
        }
        BlockPos blockposition = NaturalSpawner.getRandomPosWithin(world, chunk);
        if (blockposition.getY() >= world.getMinBuildHeight() + 1) {
            return NaturalSpawner.spawnCategoryForPosition(group, world, chunk, blockposition, checker, runner, maxSpawns, trackEntity);
        }
        return 0;
    }

    private static BlockPos getRandomPosInChunk(Level world, LevelChunk chunk) {
        ChunkPos chunkPos = chunk.getPos();
        int x = chunkPos.getMinBlockX() + world.random.nextInt(16);
        int z = chunkPos.getMinBlockZ() + world.random.nextInt(16);
        int y = world.random.nextInt(16) + 1;
        return new BlockPos(x, y, z);
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(MobCategory group, ServerLevel world, BlockPos pos) {
        NaturalSpawner.spawnCategoryForPosition(group, world, world.getChunk(pos), pos, (entitytypes, blockposition1, ichunkaccess) -> true, (entityinsentient, ichunkaccess) -> {});
    }

    public static void spawnCategoryForPosition(MobCategory group, ServerLevel world, ChunkAccess chunk, BlockPos pos, SpawnPredicate checker, AfterSpawnCallback runner) {
        NaturalSpawner.spawnCategoryForPosition(group, world, chunk, pos, checker, runner, Integer.MAX_VALUE, null);
    }

    public static int spawnCategoryForPosition(MobCategory group, ServerLevel world, ChunkAccess chunk, BlockPos pos, SpawnPredicate checker, AfterSpawnCallback runner, int maxSpawns, Consumer<Entity> trackEntity) {
        StructureManager structuremanager = world.structureManager();
        ChunkGenerator chunkgenerator = world.getChunkSource().getGenerator();
        int i = pos.getY();
        BlockState iblockdata = world.getBlockStateIfLoadedAndInBounds(pos);
        int j = 0;
        if (iblockdata != null && !iblockdata.isRedstoneConductor(chunk, pos)) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            block0: for (int k = 0; k < 3; ++k) {
                int l = pos.getX();
                int i1 = pos.getZ();
                boolean flag = true;
                MobSpawnSettings.SpawnerData biomesettingsmobs_c = null;
                SpawnGroupData groupdataentity = null;
                int j1 = Mth.ceil(world.random.nextFloat() * 4.0f);
                int k1 = 0;
                for (int l1 = 0; l1 < j1; ++l1) {
                    PreSpawnStatus doSpawning;
                    blockposition_mutableblockposition.set(l += world.random.nextInt(6) - world.random.nextInt(6), i, i1 += world.random.nextInt(6) - world.random.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    Player entityhuman = world.getNearestPlayer(d0, (double)i, d1, -1.0, false);
                    if (entityhuman == null) continue;
                    double d2 = entityhuman.distanceToSqr(d0, i, d1);
                    if (!world.isLoadedAndInBounds(blockposition_mutableblockposition) || !NaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(world, chunk, blockposition_mutableblockposition, d2)) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = NaturalSpawner.getRandomSpawnMobAt(world, structuremanager, chunkgenerator, group, world.random, blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        j1 = biomesettingsmobs_c.minCount + world.random.nextInt(1 + biomesettingsmobs_c.maxCount - biomesettingsmobs_c.minCount);
                    }
                    if ((doSpawning = NaturalSpawner.isValidSpawnPostitionForType(world, group, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2)) == PreSpawnStatus.ABORT || doSpawning == PreSpawnStatus.CANCELLED) {
                        world.getChunkSource().chunkMap.updateFailurePlayerMobTypeMap(blockposition_mutableblockposition.getX() >> 4, blockposition_mutableblockposition.getZ() >> 4, group);
                    }
                    if (doSpawning == PreSpawnStatus.ABORT) {
                        return j;
                    }
                    if (doSpawning != PreSpawnStatus.SUCCESS || !checker.test(biomesettingsmobs_c.type, blockposition_mutableblockposition, chunk)) continue;
                    Mob entityinsentient = NaturalSpawner.getMobForSpawn(world, biomesettingsmobs_c.type);
                    if (entityinsentient == null) {
                        return j;
                    }
                    entityinsentient.moveTo(d0, i, d1, world.random.nextFloat() * 360.0f, 0.0f);
                    if (!NaturalSpawner.isValidPositionForMob(world, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.finalizeSpawn(world, world.getCurrentDifficultyAt(entityinsentient.blockPosition()), MobSpawnType.NATURAL, groupdataentity);
                    world.addFreshEntityWithPassengers(entityinsentient, entityinsentient instanceof Ocelot && !((Ageable)entityinsentient.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.isRemoved()) {
                        ++j;
                        ++k1;
                        runner.run(entityinsentient, chunk);
                        if (trackEntity != null) {
                            trackEntity.accept(entityinsentient);
                        }
                    }
                    if (j >= entityinsentient.getMaxSpawnClusterSize() || j >= maxSpawns) {
                        return j;
                    }
                    if (entityinsentient.isMaxGroupSizeReached(k1)) continue block0;
                }
            }
        }
        return j;
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel world, ChunkAccess chunk, BlockPos.MutableBlockPos pos, double squaredDistance) {
        return squaredDistance <= 576.0 ? false : (world.getSharedSpawnPos().closerToCenterThan(new Vec3((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5), 24.0) ? false : Objects.equals(new ChunkPos(pos), chunk.getPos()) || world.isNaturalSpawningAllowed(pos));
    }

    private static PreSpawnStatus isValidSpawnPostitionForType(ServerLevel world, MobCategory group, StructureManager structureAccessor, ChunkGenerator chunkGenerator, MobSpawnSettings.SpawnerData spawnEntry, BlockPos.MutableBlockPos pos, double squaredDistance) {
        EntityType<?> entitytypes = spawnEntry.type;
        PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(world, pos), CraftEntityType.minecraftToBukkit(entitytypes), CreatureSpawnEvent.SpawnReason.NATURAL);
        if (!event.callEvent()) {
            if (event.shouldAbortSpawn()) {
                return PreSpawnStatus.ABORT;
            }
            return PreSpawnStatus.CANCELLED;
        }
        return entitytypes.getCategory() == MobCategory.MISC ? PreSpawnStatus.FAIL : (!entitytypes.canSpawnFarFromPlayer() && squaredDistance > (double)(entitytypes.getCategory().getDespawnDistance() * entitytypes.getCategory().getDespawnDistance()) ? PreSpawnStatus.FAIL : (entitytypes.canSummon() && NaturalSpawner.canSpawnMobAt(world, structureAccessor, chunkGenerator, group, spawnEntry, pos) ? (!SpawnPlacements.isSpawnPositionOk(entitytypes, world, pos) ? PreSpawnStatus.FAIL : (!SpawnPlacements.checkSpawnRules(entitytypes, world, MobSpawnType.NATURAL, pos, world.random) ? PreSpawnStatus.FAIL : (world.noCollision(entitytypes.getSpawnAABB((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5)) ? PreSpawnStatus.SUCCESS : PreSpawnStatus.FAIL))) : PreSpawnStatus.FAIL));
    }

    @Nullable
    private static Mob getMobForSpawn(ServerLevel world, EntityType<?> type) {
        try {
            Object entity = type.create(world);
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                return entityinsentient;
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(type));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
            ServerInternalException.reportInternalException((Throwable)exception);
        }
        return null;
    }

    private static boolean isValidPositionForMob(ServerLevel world, Mob entity, double squaredDistance) {
        return squaredDistance > (double)(entity.getType().getCategory().getDespawnDistance() * entity.getType().getCategory().getDespawnDistance()) && entity.removeWhenFarAway(squaredDistance) ? false : entity.checkSpawnRules(world, MobSpawnType.NATURAL) && entity.checkSpawnObstruction(world);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, MobCategory spawnGroup, RandomSource random, BlockPos pos) {
        Holder<Biome> holder = world.getBiome(pos);
        return spawnGroup == MobCategory.WATER_AMBIENT && holder.is(BiomeTags.REDUCED_WATER_AMBIENT_SPAWNS) && random.nextFloat() < 0.98f ? Optional.empty() : NaturalSpawner.mobsAt(world, structureAccessor, chunkGenerator, spawnGroup, pos, holder).getRandom(random);
    }

    private static boolean canSpawnMobAt(ServerLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, MobCategory spawnGroup, MobSpawnSettings.SpawnerData spawnEntry, BlockPos pos) {
        return NaturalSpawner.mobsAt(world, structureAccessor, chunkGenerator, spawnGroup, pos, null).unwrap().contains(spawnEntry);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, MobCategory spawnGroup, BlockPos pos, @Nullable Holder<Biome> biomeEntry) {
        return NaturalSpawner.isInNetherFortressBounds(pos, world, spawnGroup, structureAccessor) ? NetherFortressStructure.FORTRESS_ENEMIES : chunkGenerator.getMobsAt(biomeEntry != null ? biomeEntry : world.getBiome(pos), structureAccessor, spawnGroup, pos);
    }

    public static boolean isInNetherFortressBounds(BlockPos pos, ServerLevel world, MobCategory spawnGroup, StructureManager structureAccessor) {
        if (spawnGroup == MobCategory.MONSTER && world.getBlockState(pos.below()).is(Blocks.NETHER_BRICKS)) {
            Structure structure = structureAccessor.registryAccess().registryOrThrow(Registries.STRUCTURE).get(BuiltinStructures.FORTRESS);
            return structure == null ? false : structureAccessor.getStructureAt(pos, structure).isValid();
        }
        return false;
    }

    private static BlockPos getRandomPosWithin(Level world, LevelChunk chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        if (LeavesConfig.useMoreThreadUnsafeRandom) {
            int i = chunkcoordintpair.getMinBlockX() + world.getThreadUnsafeRandom().nextInt(16);
            int j = chunkcoordintpair.getMinBlockZ() + world.getThreadUnsafeRandom().nextInt(16);
            int k = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
            int l = Mth.randomBetweenInclusive(world.getThreadUnsafeRandom(), world.getMinBuildHeight(), k);
            return new BlockPos(i, l, j);
        }
        int i = chunkcoordintpair.getMinBlockX() + world.random.nextInt(16);
        int j = chunkcoordintpair.getMinBlockZ() + world.random.nextInt(16);
        int k = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = Mth.randomBetweenInclusive(world.random, world.getMinBuildHeight(), k);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(BlockGetter blockView, BlockPos pos, BlockState state, FluidState fluidState, EntityType<?> entityType) {
        return state.isCollisionShapeFullBlock(blockView, pos) ? false : (state.isSignalSource() ? false : (!fluidState.isEmpty() ? false : (state.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE) ? false : !entityType.isBlockDangerous(state))));
    }

    public static void spawnMobsForChunkGeneration(ServerLevelAccessor world, Holder<Biome> biomeEntry, ChunkPos chunkPos, RandomSource random) {
        MobSpawnSettings biomesettingsmobs = biomeEntry.value().getMobSettings();
        WeightedRandomList<MobSpawnSettings.SpawnerData> weightedrandomlist = biomesettingsmobs.getMobs(MobCategory.CREATURE);
        if (!weightedrandomlist.isEmpty()) {
            int i = chunkPos.getMinBlockX();
            int j = chunkPos.getMinBlockZ();
            while (random.nextFloat() < biomesettingsmobs.getCreatureProbability()) {
                Optional<MobSpawnSettings.SpawnerData> optional = weightedrandomlist.getRandom(random);
                if (optional.isEmpty()) continue;
                MobSpawnSettings.SpawnerData biomesettingsmobs_c = optional.get();
                int k = biomesettingsmobs_c.minCount + random.nextInt(1 + biomesettingsmobs_c.maxCount - biomesettingsmobs_c.minCount);
                SpawnGroupData groupdataentity = null;
                int l = i + random.nextInt(16);
                int i1 = j + random.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockposition = NaturalSpawner.getTopNonCollidingPos(world, biomesettingsmobs_c.type, l, i1);
                        if (biomesettingsmobs_c.type.canSummon() && SpawnPlacements.isSpawnPositionOk(biomesettingsmobs_c.type, world, blockposition)) {
                            Mob entityinsentient;
                            Object entity;
                            float f = biomesettingsmobs_c.type.getWidth();
                            double d0 = Mth.clamp((double)l, (double)i + (double)f, (double)i + 16.0 - (double)f);
                            double d1 = Mth.clamp((double)i1, (double)j + (double)f, (double)j + 16.0 - (double)f);
                            if (!world.noCollision(biomesettingsmobs_c.type.getSpawnAABB(d0, blockposition.getY(), d1)) || !SpawnPlacements.checkSpawnRules(biomesettingsmobs_c.type, world, MobSpawnType.CHUNK_GENERATION, BlockPos.containing(d0, blockposition.getY(), d1), world.getRandom())) continue;
                            try {
                                entity = biomesettingsmobs_c.type.create(world.getLevel());
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to create mob", (Throwable)exception);
                                ServerInternalException.reportInternalException((Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).moveTo(d0, blockposition.getY(), d1, random.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof Mob && (entityinsentient = (Mob)entity).checkSpawnRules(world, MobSpawnType.CHUNK_GENERATION) && entityinsentient.checkSpawnObstruction(world)) {
                                groupdataentity = entityinsentient.finalizeSpawn(world, world.getCurrentDifficultyAt(entityinsentient.blockPosition()), MobSpawnType.CHUNK_GENERATION, groupdataentity);
                                world.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l += random.nextInt(5) - random.nextInt(5);
                        i1 += random.nextInt(5) - random.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + random.nextInt(5) - random.nextInt(5);
                            i1 = k1 + random.nextInt(5) - random.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(LevelReader world, EntityType<?> entityType, int x, int z) {
        int k = world.getHeight(SpawnPlacements.getHeightmapType(entityType), x, z);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(x, k, z);
        if (world.dimensionType().hasCeiling()) {
            do {
                blockposition_mutableblockposition.move(Direction.DOWN);
            } while (!world.getBlockState(blockposition_mutableblockposition).isAir());
            do {
                blockposition_mutableblockposition.move(Direction.DOWN);
            } while (world.getBlockState(blockposition_mutableblockposition).isAir() && blockposition_mutableblockposition.getY() > world.getMinBuildHeight());
        }
        return SpawnPlacements.getPlacementType(entityType).adjustSpawnPosition(world, blockposition_mutableblockposition.immutable());
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<LevelChunk> var3);
    }

    public static class SpawnState {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
        private final PotentialCalculator spawnPotential;
        private final Object2IntMap<MobCategory> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPos lastCheckedPos;
        @Nullable
        private EntityType<?> lastCheckedType;
        private double lastCharge;

        SpawnState(int spawningChunkCount, Object2IntOpenHashMap<MobCategory> groupToCount, PotentialCalculator densityField, LocalMobCapCalculator densityCapper) {
            this.spawnableChunkCount = spawningChunkCount;
            this.mobCategoryCounts = groupToCount;
            this.spawnPotential = densityField;
            this.localMobCapCalculator = densityCapper;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(groupToCount);
        }

        private boolean canSpawn(EntityType<?> type, BlockPos pos, ChunkAccess chunk) {
            double d0;
            this.lastCheckedPos = pos;
            this.lastCheckedType = type;
            MobSpawnSettings.MobSpawnCost biomesettingsmobs_b = NaturalSpawner.getRoughBiome(pos, chunk).getMobSettings().getMobSpawnCost(type);
            if (biomesettingsmobs_b == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = d0 = biomesettingsmobs_b.charge();
            double d1 = this.spawnPotential.getPotentialEnergyChange(pos, d0);
            return d1 <= biomesettingsmobs_b.energyBudget();
        }

        private void afterSpawn(Mob entity, ChunkAccess chunk) {
            MobSpawnSettings.MobSpawnCost biomesettingsmobs_b;
            EntityType<?> entitytypes = entity.getType();
            BlockPos blockposition = entity.blockPosition();
            double d0 = blockposition.equals(this.lastCheckedPos) && entitytypes == this.lastCheckedType ? this.lastCharge : ((biomesettingsmobs_b = NaturalSpawner.getRoughBiome(blockposition, chunk).getMobSettings().getMobSpawnCost(entitytypes)) != null ? biomesettingsmobs_b.charge() : 0.0);
            this.spawnPotential.addCharge(blockposition, d0);
            MobCategory enumcreaturetype = entitytypes.getCategory();
            this.mobCategoryCounts.addTo((Object)enumcreaturetype, 1);
            if (this.localMobCapCalculator != null) {
                this.localMobCapCalculator.addMob(new ChunkPos(blockposition), enumcreaturetype);
            }
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<MobCategory> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategory(MobCategory enumcreaturetype, ChunkPos chunkcoordintpair, int limit) {
            int i = limit * this.spawnableChunkCount / MAGIC_NUMBER;
            if (this.localMobCapCalculator == null) {
                return this.mobCategoryCounts.getInt((Object)enumcreaturetype) < i;
            }
            return this.mobCategoryCounts.getInt((Object)enumcreaturetype) >= i ? false : this.localMobCapCalculator.canSpawn(enumcreaturetype, chunkcoordintpair);
        }
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean test(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void run(Mob var1, ChunkAccess var2);
    }

    private static enum PreSpawnStatus {
        FAIL,
        SUCCESS,
        CANCELLED,
        ABORT;

    }
}

