/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CherryLeavesBlock
extends LeavesBlock {
    public static final MapCodec<CherryLeavesBlock> CODEC = CherryLeavesBlock.simpleCodec(CherryLeavesBlock::new);

    @Override
    public MapCodec<CherryLeavesBlock> codec() {
        return CODEC;
    }

    public CherryLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (random.nextInt(10) != 0) {
            return;
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (CherryLeavesBlock.isFaceFull(blockState.getCollisionShape(world, blockPos), Direction.UP)) {
            return;
        }
        ParticleUtils.spawnParticleBelow(world, pos, random, ParticleTypes.CHERRY_LEAVES);
    }
}

