/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class CropBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<CropBlock> CODEC = CropBlock.simpleCodec(CropBlock::new);
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    public MapCodec<? extends CropBlock> codec() {
        return CODEC;
    }

    protected CropBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(this.getAgeProperty(), 0));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    @Override
    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(Blocks.FARMLAND);
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(BlockState state) {
        return state.getValue(this.getAgeProperty());
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.defaultBlockState().setValue(this.getAgeProperty(), age);
    }

    public final boolean isMaxAge(BlockState state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    @Override
    protected boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        if (world.getRawBrightness(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge()) {
            float f = CropBlock.getGrowthSpeed(this, world, pos);
            int modifier = this == Blocks.BEETROOTS ? world.spigotConfig.beetrootModifier : (this == Blocks.CARROTS ? world.spigotConfig.carrotModifier : (this == Blocks.POTATOES ? world.spigotConfig.potatoModifier : (this == Blocks.TORCHFLOWER_CROP ? world.spigotConfig.torchFlowerModifier : world.spigotConfig.wheatModifier)));
            if ((double)random.nextFloat() < (double)modifier / (100.0 * Math.floor(25.0f / f + 1.0f))) {
                CraftEventFactory.handleBlockGrowEvent(world, pos, this.getStateForAge(i + 1), 2);
            }
        }
    }

    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(world);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        CraftEventFactory.handleBlockGrowEvent(world, pos, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level world) {
        return Mth.nextInt(world.random, 2, 5);
    }

    protected static float getGrowthSpeed(Block block, BlockGetter world, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockposition1 = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState iblockdata = world.getBlockState(blockposition1.offset(i, 0, j));
                if (iblockdata.is(Blocks.FARMLAND)) {
                    f1 = 1.0f;
                    if (iblockdata.getValue(FarmBlock.MOISTURE) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockposition2 = pos.north();
        BlockPos blockposition3 = pos.south();
        BlockPos blockposition4 = pos.west();
        BlockPos blockposition5 = pos.east();
        boolean flag = world.getBlockState(blockposition4).is(block) || world.getBlockState(blockposition5).is(block);
        boolean bl = flag1 = world.getBlockState(blockposition2).is(block) || world.getBlockState(blockposition3).is(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = world.getBlockState(blockposition4.north()).is(block) || world.getBlockState(blockposition5.north()).is(block) || world.getBlockState(blockposition5.south()).is(block) || world.getBlockState(blockposition4.south()).is(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return CropBlock.hasSufficientLight(world, pos) && super.canSurvive(state, world, pos);
    }

    protected static boolean hasSufficientLight(LevelReader world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) >= 8;
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity instanceof Ravager && CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.AIR.defaultBlockState(), !world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
            world.destroyBlock(pos, true, entity);
        }
        super.entityInside(state, world, pos, entity);
    }

    protected ItemLike getBaseSeedId() {
        return Items.WHEAT_SEEDS;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.growCrops(world, pos, state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE);
    }
}

