/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public class LightningRodBlock
extends RodBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<LightningRodBlock> CODEC = LightningRodBlock.simpleCodec(LightningRodBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int ACTIVATION_TICKS = 8;
    public static final int RANGE = 128;
    private static final int SPARK_CYCLE = 200;

    public MapCodec<LightningRodBlock> codec() {
        return CODEC;
    }

    public LightningRodBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(DirectionalBlock.FACING, Direction.UP)).setValue(WATERLOGGED, false)).setValue(POWERED, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean flag = fluid.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, ctx.getClickedFace())).setValue(WATERLOGGED, flag);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            world.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false && state.getValue(DirectionalBlock.FACING) == direction ? 15 : 0;
    }

    public void onLightningStrike(BlockState state, Level world, BlockPos pos) {
        boolean powered = state.getValue(POWERED);
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        world.setBlock(pos, (BlockState)state.setValue(POWERED, true), 3);
        this.updateNeighbours(state, world, pos);
        world.scheduleTick(pos, this, 8);
        world.levelEvent(3002, pos, state.getValue(DirectionalBlock.FACING).getAxis().ordinal());
    }

    private void updateNeighbours(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos.relative(state.getValue(DirectionalBlock.FACING).getOpposite()), this);
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.setBlock(pos, (BlockState)state.setValue(POWERED, false), 3);
        this.updateNeighbours(state, world, pos);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.isThundering() && (long)world.random.nextInt(200) <= world.getGameTime() % 200L && pos.getY() == world.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - 1) {
            ParticleUtils.spawnParticlesAlongAxis(state.getValue(DirectionalBlock.FACING).getAxis(), world, pos, 0.125, ParticleTypes.ELECTRIC_SPARK, UniformInt.of(1, 2));
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            if (state.getValue(POWERED).booleanValue()) {
                this.updateNeighbours(state, world, pos);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(oldState.getBlock()) && state.getValue(POWERED).booleanValue() && !world.getBlockTicks().hasScheduledTick(pos, this)) {
            world.setBlock(pos, (BlockState)state.setValue(POWERED, false), 18);
        }
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockposition;
        if (world.isThundering() && projectile instanceof ThrownTrident && ((ThrownTrident)projectile).isChanneling() && world.canSeeSky(blockposition = hit.getBlockPos())) {
            LightningBolt entitylightning = EntityType.LIGHTNING_BOLT.create(world);
            if (entitylightning != null) {
                entitylightning.moveTo(Vec3.atBottomCenterOf(blockposition.above()));
                Entity entity = projectile.getOwner();
                entitylightning.setCause(entity instanceof ServerPlayer ? (ServerPlayer)entity : null);
                ((ServerLevel)world).strikeLightning(entitylightning, LightningStrikeEvent.Cause.TRIDENT);
            }
            world.playSound((Player)null, blockposition, SoundEvents.TRIDENT_THUNDER, SoundSource.WEATHER, 5.0f, 1.0f);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(DirectionalBlock.FACING, POWERED, WATERLOGGED);
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }
}

