/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.util.RedstoneWireTurbo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.WorldConfiguration;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.leavesmc.leaves.LeavesConfig;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vec3[] COLORS = Util.make(new Vec3[16], avec3d -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.clamp(f * f * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = Mth.clamp(f * f * 0.6f - 0.7f, 0.0f, 1.0f);
            avec3d[i] = new Vec3(f1, f2, f3);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    public boolean shouldSignal = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
        for (BlockState iblockdata : this.getStateDefinition().getPossibleStates()) {
            if (iblockdata.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put(iblockdata, this.calculateShape(iblockdata));
        }
    }

    private VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            RedstoneSide blockpropertyredstoneside = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
            if (blockpropertyredstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.or(voxelshape, SHAPES_FLOOR.get(enumdirection));
                continue;
            }
            if (blockpropertyredstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.or(voxelshape, SHAPES_UP.get(enumdirection));
        }
        return voxelshape;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES_CACHE.get(state.setValue(POWER, 0));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getConnectionState(ctx.getLevel(), this.crossState, ctx.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag6;
        boolean flag = RedStoneWireBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.defaultBlockState().setValue(POWER, state.getValue(POWER)), pos);
        if (flag && RedStoneWireBlock.isDot(state)) {
            return state;
        }
        boolean flag1 = state.getValue(NORTH).isConnected();
        boolean flag2 = state.getValue(SOUTH).isConnected();
        boolean flag3 = state.getValue(EAST).isConnected();
        boolean flag4 = state.getValue(WEST).isConnected();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            state = (BlockState)state.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            state = (BlockState)state.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            state = (BlockState)state.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            state = (BlockState)state.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag = !world.getBlockState(pos.above()).isRedstoneConductor(world, pos);
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected()) continue;
            RedstoneSide blockpropertyredstoneside = this.getConnectingSide(world, pos, enumdirection, flag);
            state = (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(enumdirection), blockpropertyredstoneside);
        }
        return state;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return LeavesConfig.redstoneDontCantOnTrapDoor ? state : (!this.canSurviveOn(world, neighborPos, neighborState) ? Blocks.AIR.defaultBlockState() : state);
        }
        if (direction == Direction.UP) {
            return this.getConnectionState(world, state, pos);
        }
        RedstoneSide blockpropertyredstoneside = this.getConnectingSide(world, pos, direction);
        return blockpropertyredstoneside.isConnected() == ((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() && !RedStoneWireBlock.isCross(state) ? (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), blockpropertyredstoneside) : this.getConnectionState(world, (BlockState)((BlockState)this.crossState.setValue(POWER, state.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(direction), blockpropertyredstoneside), pos);
    }

    private static boolean isCross(BlockState state) {
        return state.getValue(NORTH).isConnected() && state.getValue(SOUTH).isConnected() && state.getValue(EAST).isConnected() && state.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState state) {
        return !state.getValue(NORTH).isConnected() && !state.getValue(SOUTH).isConnected() && !state.getValue(EAST).isConnected() && !state.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState state, LevelAccessor world, BlockPos pos, int flags, int maxUpdateDepth) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            RedstoneSide blockpropertyredstoneside = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
            if (blockpropertyredstoneside == RedstoneSide.NONE || world.getBlockState(blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection)).is(this)) continue;
            blockposition_mutableblockposition.move(Direction.DOWN);
            BlockState iblockdata1 = world.getBlockState(blockposition_mutableblockposition);
            if (iblockdata1.is(this)) {
                Vec3i blockposition1 = blockposition_mutableblockposition.relative(enumdirection.getOpposite());
                world.neighborShapeChanged(enumdirection.getOpposite(), world.getBlockState((BlockPos)blockposition1), blockposition_mutableblockposition, (BlockPos)blockposition1, flags, maxUpdateDepth);
            }
            blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection).move(Direction.UP);
            BlockState iblockdata2 = world.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata2.is(this)) continue;
            Vec3i blockposition2 = blockposition_mutableblockposition.relative(enumdirection.getOpposite());
            world.neighborShapeChanged(enumdirection.getOpposite(), world.getBlockState((BlockPos)blockposition2), blockposition_mutableblockposition, (BlockPos)blockposition2, flags, maxUpdateDepth);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction direction) {
        return this.getConnectingSide(world, pos, direction, !world.getBlockState(pos.above()).isRedstoneConductor(world, pos));
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction direction, boolean flag) {
        BlockPos blockposition1 = pos.relative(direction);
        BlockState iblockdata = world.getBlockState(blockposition1);
        if (flag) {
            boolean flag1;
            boolean bl = flag1 = !LeavesConfig.redstoneDontCantOnTrapDoor && iblockdata.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(world, blockposition1, iblockdata);
            if (flag1 && RedStoneWireBlock.shouldConnectTo(world.getBlockState(blockposition1.above()))) {
                if (iblockdata.isFaceSturdy(world, blockposition1, direction.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !RedStoneWireBlock.shouldConnectTo(iblockdata, direction) && (iblockdata.isRedstoneConductor(world, blockposition1) || !RedStoneWireBlock.shouldConnectTo(world.getBlockState(blockposition1.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockposition1 = pos.below();
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        return this.canSurviveOn(world, blockposition1, iblockdata1);
    }

    private boolean canSurviveOn(BlockGetter world, BlockPos pos, BlockState floor) {
        return floor.isFaceSturdy(world, pos, Direction.UP) || floor.is(Blocks.HOPPER);
    }

    private void updateSurroundingRedstone(Level worldIn, BlockPos pos, BlockState state, BlockPos source) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.updatePowerStrength(worldIn, pos, state);
    }

    public BlockState calculateCurrentChanges(Level worldIn, BlockPos pos1, BlockPos pos2, BlockState state) {
        BlockState iblockstate = state;
        int i = state.getValue(POWER);
        int j = 0;
        j = this.getPower(j, worldIn.getBlockState(pos2));
        this.shouldSignal = false;
        int k = worldIn.getBestNeighborSignal(pos1);
        this.shouldSignal = true;
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA && k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA || k < 15) {
            for (Direction enumfacing : Direction.Plane.HORIZONTAL) {
                boolean flag;
                BlockPos blockpos = pos1.relative(enumfacing);
                boolean bl = flag = blockpos.getX() != pos2.getX() || blockpos.getZ() != pos2.getZ();
                if (flag) {
                    l = this.getPower(l, worldIn.getBlockState(blockpos));
                }
                if (worldIn.getBlockState(blockpos).isRedstoneConductor(worldIn, blockpos) && !worldIn.getBlockState(pos1.above()).isRedstoneConductor(worldIn, pos1)) {
                    if (!flag || pos1.getY() < pos2.getY()) continue;
                    l = this.getPower(l, worldIn.getBlockState(blockpos.above()));
                    continue;
                }
                if (worldIn.getBlockState(blockpos).isRedstoneConductor(worldIn, blockpos) || !flag || pos1.getY() > pos2.getY()) continue;
                l = this.getPower(l, worldIn.getBlockState(blockpos.below()));
            }
        }
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.VANILLA) {
            j = l > j ? l - 1 : (j > 0 ? --j : 0);
            if (k > j - 1) {
                j = k;
            }
        } else {
            j = l - 1;
            if (k > j) {
                j = k;
            }
        }
        if (i != j) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(worldIn, pos1), i, j);
            worldIn.getCraftServer().getPluginManager().callEvent((Event)event);
            j = event.getNewCurrent();
            state = (BlockState)state.setValue(POWER, j);
            if (worldIn.getBlockState(pos1) == iblockstate && worldIn.setBlock(pos1, state, 18)) {
                this.turbo.updateNeighborShapes(worldIn, pos1, state);
            }
        }
        return state;
    }

    private void updatePowerStrength(Level world, BlockPos pos, BlockState state) {
        int i = this.calculateTargetStrength(world, pos);
        int oldPower = state.getValue(POWER);
        if (oldPower != i) {
            BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ()), oldPower, i);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            i = event.getNewCurrent();
        }
        if (oldPower != i) {
            if (world.getBlockState(pos) == state) {
                world.setBlock(pos, (BlockState)state.setValue(POWER, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction enumdirection : Direction.values()) {
                set.add(pos.relative(enumdirection));
            }
            for (BlockPos blockposition1 : set) {
                world.updateNeighborsAt(blockposition1, this);
            }
        }
    }

    private int calculateTargetStrength(Level world, BlockPos pos) {
        this.shouldSignal = false;
        int i = world.getBestNeighborSignal(pos);
        this.shouldSignal = true;
        int j = 0;
        if (i < 15) {
            for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                BlockPos blockposition1 = pos.relative(enumdirection);
                BlockState iblockdata = world.getBlockState(blockposition1);
                j = Math.max(j, this.getWireSignal(iblockdata));
                BlockPos blockposition2 = pos.above();
                if (iblockdata.isRedstoneConductor(world, blockposition1) && !world.getBlockState(blockposition2).isRedstoneConductor(world, blockposition2)) {
                    j = Math.max(j, this.getWireSignal(world.getBlockState(blockposition1.above())));
                    continue;
                }
                if (iblockdata.isRedstoneConductor(world, blockposition1)) continue;
                j = Math.max(j, this.getWireSignal(world.getBlockState(blockposition1.below())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getPower(int min, BlockState iblockdata) {
        return Math.max(min, this.getWireSignal(iblockdata));
    }

    private int getWireSignal(BlockState state) {
        return state.is(this) ? state.getValue(POWER) : 0;
    }

    private void checkCornerChangeAt(Level world, BlockPos pos) {
        if (world.getBlockState(pos).is(this)) {
            world.updateNeighborsAt(pos, this);
            for (Direction enumdirection : Direction.values()) {
                world.updateNeighborsAt(pos.relative(enumdirection), this);
            }
        }
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock()) && !world.isClientSide) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireAdded(pos);
            } else {
                this.updateSurroundingRedstone(world, pos, state, null);
            }
            for (Direction enumdirection : Direction.Plane.VERTICAL) {
                world.updateNeighborsAt(pos.relative(enumdirection), this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && !state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
            if (!world.isClientSide) {
                for (Direction enumdirection : Direction.values()) {
                    world.updateNeighborsAt(pos.relative(enumdirection), this);
                }
                if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                    world.getWireHandler().onWireRemoved(pos, state);
                } else {
                    this.updateSurroundingRedstone(world, pos, state, null);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level world, BlockPos pos) {
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.relative(enumdirection));
        }
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            if (world.getBlockState(blockposition1).isRedstoneConductor(world, blockposition1)) {
                this.checkCornerChangeAt(world, blockposition1.above());
                continue;
            }
            this.checkCornerChangeAt(world, blockposition1.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!world.isClientSide) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireUpdated(pos);
            } else if (state.canSurvive(world, pos)) {
                this.updateSurroundingRedstone(world, pos, state, sourcePos);
            } else {
                RedStoneWireBlock.dropResources(state, world, pos);
                world.removeBlock(pos, false);
            }
        }
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return !this.shouldSignal ? 0 : state.getSignal(world, pos, direction);
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (this.shouldSignal && direction != Direction.DOWN) {
            int i = state.getValue(POWER);
            return i == 0 ? 0 : (direction != Direction.UP && !((RedstoneSide)this.getConnectionState(world, state, pos).getValue(PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).isConnected() ? 0 : i);
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState state) {
        return RedStoneWireBlock.shouldConnectTo(state, null);
    }

    protected static boolean shouldConnectTo(BlockState state, @Nullable Direction dir) {
        if (state.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (state.is(Blocks.REPEATER)) {
            Direction enumdirection1 = state.getValue(HorizontalDirectionalBlock.FACING);
            return enumdirection1 == dir || enumdirection1.getOpposite() == dir;
        }
        return state.is(Blocks.OBSERVER) ? dir == state.getValue(DirectionalBlock.FACING) : state.isSignalSource() && dir != null;
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int powerLevel) {
        Vec3 vec3d = COLORS[powerLevel];
        return Mth.color((float)vec3d.x(), (float)vec3d.y(), (float)vec3d.z());
    }

    private void spawnParticlesAlongLine(Level world, RandomSource random, BlockPos pos, Vec3 color, Direction enumdirection, Direction enumdirection1, float f, float f1) {
        float f2 = f1 - f;
        if (random.nextFloat() < 0.2f * f2) {
            float f3 = 0.4375f;
            float f4 = f + f2 * random.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepX()) + (double)(f4 * (float)enumdirection1.getStepX());
            double d1 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepY()) + (double)(f4 * (float)enumdirection1.getStepY());
            double d2 = 0.5 + (double)(0.4375f * (float)enumdirection.getStepZ()) + (double)(f4 * (float)enumdirection1.getStepZ());
            world.addParticle(new DustParticleOptions(color.toVector3f(), 1.0f), (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i = state.getValue(POWER);
        if (i != 0) {
            block4: for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                RedstoneSide blockpropertyredstoneside = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(enumdirection));
                switch (blockpropertyredstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(world, random, pos, COLORS[i], enumdirection, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(world, random, pos, COLORS[i], Direction.DOWN, enumdirection, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, random, pos, COLORS[i], Direction.DOWN, enumdirection, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(EAST, state.getValue(WEST))).setValue(SOUTH, state.getValue(NORTH))).setValue(WEST, state.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(EAST))).setValue(EAST, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(WEST))).setValue(WEST, state.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(WEST))).setValue(EAST, state.getValue(NORTH))).setValue(SOUTH, state.getValue(EAST))).setValue(WEST, state.getValue(SOUTH));
            }
        }
        return state;
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, state.getValue(WEST))).setValue(WEST, state.getValue(EAST));
            }
        }
        return super.mirror(state, mirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(state) || RedStoneWireBlock.isDot(state)) {
            BlockState iblockdata1 = RedStoneWireBlock.isCross(state) ? this.defaultBlockState() : this.crossState;
            iblockdata1 = (BlockState)iblockdata1.setValue(POWER, state.getValue(POWER));
            if ((iblockdata1 = this.getConnectionState(world, iblockdata1, pos)) != state) {
                world.setBlock(pos, iblockdata1, 3);
                this.updatesOnShapeChange(world, pos, state, iblockdata1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level world, BlockPos pos, BlockState oldState, BlockState newState) {
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            if (((RedstoneSide)oldState.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected() == ((RedstoneSide)newState.getValue(PROPERTY_BY_DIRECTION.get(enumdirection))).isConnected() || !world.getBlockState(blockposition1).isRedstoneConductor(world, blockposition1)) continue;
            world.updateNeighborsAtExceptFromFacing(blockposition1, newState.getBlock(), enumdirection.getOpposite());
        }
    }
}

