/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> CODEC = SculkBlock.simpleCodec(SculkBlock::new);

    public MapCodec<SculkBlock> codec() {
        return CODEC;
    }

    public SculkBlock(BlockBehaviour.Properties settings) {
        super(ConstantInt.of(1), settings);
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor world, BlockPos catalystPos, RandomSource random, SculkSpreader spreadManager, boolean shouldConvertToBlock) {
        int i = cursor.getCharge();
        if (i != 0 && random.nextInt(spreadManager.chargeDecayRate()) == 0) {
            BlockPos blockposition1 = cursor.getPos();
            boolean flag1 = blockposition1.closerThan(catalystPos, spreadManager.noGrowthRadius());
            if (!flag1 && SculkBlock.canPlaceGrowth(world, blockposition1)) {
                BlockState iblockdata;
                BlockPos blockposition2;
                int j = spreadManager.growthSpawnCost();
                if (random.nextInt(j) < i && CraftEventFactory.handleBlockSpreadEvent(world, catalystPos, blockposition2 = blockposition1.above(), iblockdata = this.getRandomGrowthState(world, blockposition2, random, spreadManager.isWorldGeneration()), 3)) {
                    world.playSound(null, blockposition1, iblockdata.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return Math.max(0, i - j);
            }
            return random.nextInt(spreadManager.additionalDecayRate()) != 0 ? i : i - (flag1 ? 1 : SculkBlock.getDecayPenalty(spreadManager, blockposition1, catalystPos, i));
        }
        return i;
    }

    private static int getDecayPenalty(SculkSpreader spreadManager, BlockPos cursorPos, BlockPos catalystPos, int charge) {
        int j = spreadManager.noGrowthRadius();
        float f = Mth.square((float)Math.sqrt(cursorPos.distSqr(catalystPos)) - (float)j);
        int k = Mth.square(24 - j);
        float f1 = Math.min(1.0f, f / (float)k);
        return Math.max(1, (int)((float)charge * f1 * 0.5f));
    }

    private BlockState getRandomGrowthState(LevelAccessor world, BlockPos pos, RandomSource random, boolean allowShrieker) {
        BlockState iblockdata = random.nextInt(11) == 0 ? (BlockState)Blocks.SCULK_SHRIEKER.defaultBlockState().setValue(SculkShriekerBlock.CAN_SUMMON, allowShrieker) : Blocks.SCULK_SENSOR.defaultBlockState();
        return iblockdata.hasProperty(BlockStateProperties.WATERLOGGED) && !world.getFluidState(pos).isEmpty() ? (BlockState)iblockdata.setValue(BlockStateProperties.WATERLOGGED, true) : iblockdata;
    }

    private static boolean canPlaceGrowth(LevelAccessor world, BlockPos pos) {
        BlockState iblockdata = world.getBlockState(pos.above());
        if (!(iblockdata.isAir() || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().is(Fluids.WATER))) {
            return false;
        }
        int i = 0;
        Iterator<BlockPos> iterator = BlockPos.betweenClosed(pos.offset(-4, 0, -4), pos.offset(4, 2, 4)).iterator();
        do {
            if (!iterator.hasNext()) {
                return true;
            }
            BlockPos blockposition1 = iterator.next();
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            if (!iblockdata1.is(Blocks.SCULK_SENSOR) && !iblockdata1.is(Blocks.SCULK_SHRIEKER)) continue;
            ++i;
        } while (i <= 2);
        return false;
    }

    @Override
    public boolean canChangeBlockStateOnSpread() {
        return false;
    }
}

