/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class TripWireHookBlock
extends Block {
    public static final MapCodec<TripWireHookBlock> CODEC = TripWireHookBlock.simpleCodec(TripWireHookBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    protected static final int AABB_OFFSET = 3;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 0.0, 10.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 0.0, 0.0, 11.0, 10.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 0.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 5.0, 6.0, 10.0, 11.0);

    public MapCodec<TripWireHookBlock> codec() {
        return CODEC;
    }

    public TripWireHookBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch (state.getValue(FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction enumdirection = state.getValue(FACING);
        BlockPos blockposition1 = pos.relative(enumdirection.getOpposite());
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        return enumdirection.getAxis().isHorizontal() && iblockdata1.isFaceSturdy(world, blockposition1, enumdirection);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.getOpposite() == state.getValue(FACING) && !state.canSurvive(world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] aenumdirection;
        BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        Level world = ctx.getLevel();
        BlockPos blockposition = ctx.getClickedPos();
        Direction[] aenumdirection1 = aenumdirection = ctx.getNearestLookingDirections();
        int i = aenumdirection.length;
        for (int j = 0; j < i; ++j) {
            Direction enumdirection1;
            Direction enumdirection = aenumdirection1[j];
            if (!enumdirection.getAxis().isHorizontal() || !(iblockdata = (BlockState)iblockdata.setValue(FACING, enumdirection1 = enumdirection.getOpposite())).canSurvive(world, blockposition)) continue;
            return iblockdata;
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        TripWireHookBlock.calculateState(world, pos, state, false, false, -1, null);
    }

    public static void calculateState(Level world, BlockPos pos, BlockState state, boolean flag, boolean flag1, int i, @Nullable BlockState iblockdata1) {
        Optional<Direction> optional = state.getOptionalValue(FACING);
        if (optional.isPresent()) {
            BlockPos blockposition1;
            Direction enumdirection = optional.get();
            boolean flag2 = state.getOptionalValue(ATTACHED).orElse(false);
            boolean flag3 = state.getOptionalValue(POWERED).orElse(false);
            Block block = state.getBlock();
            boolean flag4 = !flag;
            boolean flag5 = false;
            int j = 0;
            BlockState[] aiblockdata = new BlockState[42];
            for (int k = 1; k < 42; ++k) {
                blockposition1 = pos.relative(enumdirection, k);
                BlockState iblockdata2 = world.getBlockState(blockposition1);
                if (iblockdata2.is(Blocks.TRIPWIRE_HOOK)) {
                    if (iblockdata2.getValue(FACING) != enumdirection.getOpposite()) break;
                    j = k;
                    break;
                }
                if (!iblockdata2.is(Blocks.TRIPWIRE) && k != i) {
                    aiblockdata[k] = null;
                    flag4 = false;
                    continue;
                }
                if (k == i) {
                    iblockdata2 = (BlockState)MoreObjects.firstNonNull((Object)iblockdata1, (Object)iblockdata2);
                }
                boolean flag6 = iblockdata2.getValue(TripWireBlock.DISARMED) == false;
                boolean flag7 = iblockdata2.getValue(TripWireBlock.POWERED);
                flag5 |= flag6 && flag7;
                aiblockdata[k] = iblockdata2;
                if (k != i) continue;
                world.scheduleTick(pos, block, 10);
                flag4 &= flag6;
            }
            BlockState iblockdata3 = (BlockState)((BlockState)block.defaultBlockState().trySetValue(ATTACHED, flag4)).trySetValue(POWERED, flag5 &= (flag4 &= j > 1));
            if (j > 0) {
                blockposition1 = pos.relative(enumdirection, j);
                Direction enumdirection1 = enumdirection.getOpposite();
                world.setBlock(blockposition1, (BlockState)iblockdata3.setValue(FACING, enumdirection1), 3);
                TripWireHookBlock.notifyNeighbors(block, world, blockposition1, enumdirection1);
                TripWireHookBlock.emitState(world, blockposition1, flag4, flag5, flag2, flag3);
            }
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), 15, 0);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0) {
                return;
            }
            TripWireHookBlock.emitState(world, pos, flag4, flag5, flag2, flag3);
            if (!flag) {
                if (world.getBlockState(pos).getBlock() == Blocks.TRIPWIRE_HOOK) {
                    world.setBlock(pos, (BlockState)iblockdata3.setValue(FACING, enumdirection), 3);
                }
                if (flag1) {
                    TripWireHookBlock.notifyNeighbors(block, world, pos, enumdirection);
                }
            }
            if (flag2 != flag4) {
                for (int l = 1; l < j; ++l) {
                    BlockPos blockposition2 = pos.relative(enumdirection, l);
                    BlockState iblockdata4 = aiblockdata[l];
                    if (iblockdata4 == null) continue;
                    world.setBlock(blockposition2, (BlockState)iblockdata4.trySetValue(ATTACHED, flag4), 3);
                    if (world.getBlockState(blockposition2).isAir()) continue;
                }
            }
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        TripWireHookBlock.calculateState(world, pos, state, false, true, -1, null);
    }

    private static void emitState(Level world, BlockPos pos, boolean attached, boolean on, boolean detached, boolean off) {
        if (on && !off) {
            world.playSound((Player)null, pos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.4f, 0.6f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ACTIVATE, pos);
        } else if (!on && off) {
            world.playSound((Player)null, pos, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 0.5f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_DEACTIVATE, pos);
        } else if (attached && !detached) {
            world.playSound((Player)null, pos, SoundEvents.TRIPWIRE_ATTACH, SoundSource.BLOCKS, 0.4f, 0.7f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ATTACH, pos);
        } else if (!attached && detached) {
            world.playSound((Player)null, pos, SoundEvents.TRIPWIRE_DETACH, SoundSource.BLOCKS, 0.4f, 1.2f / (world.random.nextFloat() * 0.2f + 0.9f));
            world.gameEvent((Entity)null, GameEvent.BLOCK_DETACH, pos);
        }
    }

    private static void notifyNeighbors(Block block, Level world, BlockPos pos, Direction direction) {
        world.updateNeighborsAt(pos, block);
        world.updateNeighborsAt(pos.relative(direction.getOpposite()), block);
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && !state.is(newState.getBlock())) {
            boolean flag1 = state.getValue(ATTACHED);
            boolean flag2 = state.getValue(POWERED);
            if (flag1 || flag2) {
                TripWireHookBlock.calculateState(world, pos, state, true, false, -1, null);
            }
            if (flag2) {
                world.updateNeighborsAt(pos, this);
                world.updateNeighborsAt(pos.relative(state.getValue(FACING).getOpposite()), this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) == false ? 0 : (state.getValue(FACING) == direction ? 15 : 0);
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, rotation.rotate(state.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FACING, POWERED, ATTACHED);
    }
}

