/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class DecoratedPotPatterns {
    private static final String BASE_NAME = "decorated_pot_base";
    public static final ResourceKey<String> BASE = DecoratedPotPatterns.create("decorated_pot_base");
    private static final String BRICK_NAME = "decorated_pot_side";
    private static final String ANGLER_NAME = "angler_pottery_pattern";
    private static final String ARCHER_NAME = "archer_pottery_pattern";
    private static final String ARMS_UP_NAME = "arms_up_pottery_pattern";
    private static final String BLADE_NAME = "blade_pottery_pattern";
    private static final String BREWER_NAME = "brewer_pottery_pattern";
    private static final String BURN_NAME = "burn_pottery_pattern";
    private static final String DANGER_NAME = "danger_pottery_pattern";
    private static final String EXPLORER_NAME = "explorer_pottery_pattern";
    private static final String FLOW_NAME = "flow_pottery_pattern";
    private static final String FRIEND_NAME = "friend_pottery_pattern";
    private static final String GUSTER_NAME = "guster_pottery_pattern";
    private static final String HEART_NAME = "heart_pottery_pattern";
    private static final String HEARTBREAK_NAME = "heartbreak_pottery_pattern";
    private static final String HOWL_NAME = "howl_pottery_pattern";
    private static final String MINER_NAME = "miner_pottery_pattern";
    private static final String MOURNER_NAME = "mourner_pottery_pattern";
    private static final String PLENTY_NAME = "plenty_pottery_pattern";
    private static final String PRIZE_NAME = "prize_pottery_pattern";
    private static final String SCRAPE_NAME = "scrape_pottery_pattern";
    private static final String SHEAF_NAME = "sheaf_pottery_pattern";
    private static final String SHELTER_NAME = "shelter_pottery_pattern";
    private static final String SKULL_NAME = "skull_pottery_pattern";
    private static final String SNORT_NAME = "snort_pottery_pattern";
    private static final ResourceKey<String> BRICK = DecoratedPotPatterns.create("decorated_pot_side");
    private static final ResourceKey<String> ANGLER = DecoratedPotPatterns.create("angler_pottery_pattern");
    private static final ResourceKey<String> ARCHER = DecoratedPotPatterns.create("archer_pottery_pattern");
    private static final ResourceKey<String> ARMS_UP = DecoratedPotPatterns.create("arms_up_pottery_pattern");
    private static final ResourceKey<String> BLADE = DecoratedPotPatterns.create("blade_pottery_pattern");
    private static final ResourceKey<String> BREWER = DecoratedPotPatterns.create("brewer_pottery_pattern");
    private static final ResourceKey<String> BURN = DecoratedPotPatterns.create("burn_pottery_pattern");
    private static final ResourceKey<String> DANGER = DecoratedPotPatterns.create("danger_pottery_pattern");
    private static final ResourceKey<String> EXPLORER = DecoratedPotPatterns.create("explorer_pottery_pattern");
    private static final ResourceKey<String> FLOW = DecoratedPotPatterns.create("flow_pottery_pattern");
    private static final ResourceKey<String> FRIEND = DecoratedPotPatterns.create("friend_pottery_pattern");
    private static final ResourceKey<String> GUSTER = DecoratedPotPatterns.create("guster_pottery_pattern");
    private static final ResourceKey<String> HEART = DecoratedPotPatterns.create("heart_pottery_pattern");
    private static final ResourceKey<String> HEARTBREAK = DecoratedPotPatterns.create("heartbreak_pottery_pattern");
    private static final ResourceKey<String> HOWL = DecoratedPotPatterns.create("howl_pottery_pattern");
    private static final ResourceKey<String> MINER = DecoratedPotPatterns.create("miner_pottery_pattern");
    private static final ResourceKey<String> MOURNER = DecoratedPotPatterns.create("mourner_pottery_pattern");
    private static final ResourceKey<String> PLENTY = DecoratedPotPatterns.create("plenty_pottery_pattern");
    private static final ResourceKey<String> PRIZE = DecoratedPotPatterns.create("prize_pottery_pattern");
    private static final ResourceKey<String> SCRAPE = DecoratedPotPatterns.create("scrape_pottery_pattern");
    private static final ResourceKey<String> SHEAF = DecoratedPotPatterns.create("sheaf_pottery_pattern");
    private static final ResourceKey<String> SHELTER = DecoratedPotPatterns.create("shelter_pottery_pattern");
    private static final ResourceKey<String> SKULL = DecoratedPotPatterns.create("skull_pottery_pattern");
    private static final ResourceKey<String> SNORT = DecoratedPotPatterns.create("snort_pottery_pattern");
    private static final Map<Item, ResourceKey<String>> ITEM_TO_POT_TEXTURE = Map.ofEntries(Map.entry(Items.BRICK, BRICK), Map.entry(Items.ANGLER_POTTERY_SHERD, ANGLER), Map.entry(Items.ARCHER_POTTERY_SHERD, ARCHER), Map.entry(Items.ARMS_UP_POTTERY_SHERD, ARMS_UP), Map.entry(Items.BLADE_POTTERY_SHERD, BLADE), Map.entry(Items.BREWER_POTTERY_SHERD, BREWER), Map.entry(Items.BURN_POTTERY_SHERD, BURN), Map.entry(Items.DANGER_POTTERY_SHERD, DANGER), Map.entry(Items.EXPLORER_POTTERY_SHERD, EXPLORER), Map.entry(Items.FLOW_POTTERY_SHERD, FLOW), Map.entry(Items.FRIEND_POTTERY_SHERD, FRIEND), Map.entry(Items.GUSTER_POTTERY_SHERD, GUSTER), Map.entry(Items.HEART_POTTERY_SHERD, HEART), Map.entry(Items.HEARTBREAK_POTTERY_SHERD, HEARTBREAK), Map.entry(Items.HOWL_POTTERY_SHERD, HOWL), Map.entry(Items.MINER_POTTERY_SHERD, MINER), Map.entry(Items.MOURNER_POTTERY_SHERD, MOURNER), Map.entry(Items.PLENTY_POTTERY_SHERD, PLENTY), Map.entry(Items.PRIZE_POTTERY_SHERD, PRIZE), Map.entry(Items.SCRAPE_POTTERY_SHERD, SCRAPE), Map.entry(Items.SHEAF_POTTERY_SHERD, SHEAF), Map.entry(Items.SHELTER_POTTERY_SHERD, SHELTER), Map.entry(Items.SKULL_POTTERY_SHERD, SKULL), Map.entry(Items.SNORT_POTTERY_SHERD, SNORT));

    private static ResourceKey<String> create(String path) {
        return ResourceKey.create(Registries.DECORATED_POT_PATTERNS, new ResourceLocation(path));
    }

    public static ResourceLocation location(ResourceKey<String> key) {
        return key.location().withPrefix("entity/decorated_pot/");
    }

    @Nullable
    public static ResourceKey<String> getResourceKey(Item sherd) {
        return ITEM_TO_POT_TEXTURE.get(sherd);
    }

    public static String bootstrap(Registry<String> registry) {
        Registry.register(registry, BRICK, BRICK_NAME);
        Registry.register(registry, ANGLER, ANGLER_NAME);
        Registry.register(registry, ARCHER, ARCHER_NAME);
        Registry.register(registry, ARMS_UP, ARMS_UP_NAME);
        Registry.register(registry, BLADE, BLADE_NAME);
        Registry.register(registry, BREWER, BREWER_NAME);
        Registry.register(registry, BURN, BURN_NAME);
        Registry.register(registry, DANGER, DANGER_NAME);
        Registry.register(registry, EXPLORER, EXPLORER_NAME);
        Registry.register(registry, FLOW, FLOW_NAME);
        Registry.register(registry, FRIEND, FRIEND_NAME);
        Registry.register(registry, GUSTER, GUSTER_NAME);
        Registry.register(registry, HEART, HEART_NAME);
        Registry.register(registry, HEARTBREAK, HEARTBREAK_NAME);
        Registry.register(registry, HOWL, HOWL_NAME);
        Registry.register(registry, MINER, MINER_NAME);
        Registry.register(registry, MOURNER, MOURNER_NAME);
        Registry.register(registry, PLENTY, PLENTY_NAME);
        Registry.register(registry, PRIZE, PRIZE_NAME);
        Registry.register(registry, SCRAPE, SCRAPE_NAME);
        Registry.register(registry, SHEAF, SHEAF_NAME);
        Registry.register(registry, SHELTER, SHELTER_NAME);
        Registry.register(registry, SKULL, SKULL_NAME);
        Registry.register(registry, SNORT, SNORT_NAME);
        return Registry.register(registry, BASE, BASE_NAME);
    }
}

