/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    private static final int DELAY_BETWEEN_PLAYER_SCANS = 20;
    private static final int TRIAL_OMEN_PER_BAD_OMEN_LEVEL = 18000;
    public static MapCodec<TrialSpawnerData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.detectedPlayers), (App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.currentMobs), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.cooldownEndsAt), (App)Codec.LONG.lenientOptionalFieldOf(TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(trialspawnerdata -> trialspawnerdata.totalMobsSpawned), (App)SpawnData.CODEC.lenientOptionalFieldOf(TAG_SPAWN_DATA).forGetter(trialspawnerdata -> trialspawnerdata.nextSpawnData), (App)ResourceKey.codec(Registries.LOOT_TABLE).lenientOptionalFieldOf("ejecting_loot_table").forGetter(trialspawnerdata -> trialspawnerdata.ejectingLootTable)).apply((Applicative)instance, TrialSpawnerData::new));
    public final Set<UUID> detectedPlayers = new HashSet<UUID>();
    public final Set<UUID> currentMobs = new HashSet<UUID>();
    public long cooldownEndsAt;
    protected long nextMobSpawnsAt;
    protected int totalMobsSpawned;
    public Optional<SpawnData> nextSpawnData;
    protected Optional<ResourceKey<LootTable>> ejectingLootTable;
    @Nullable
    protected Entity displayEntity;
    @Nullable
    private SimpleWeightedRandomList<ItemStack> dispensing;
    protected double spin;
    protected double oSpin;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> players, Set<UUID> spawnedMobsAlive, long cooldownEnd, long nextMobSpawnsAt, int totalSpawnedMobs, Optional<SpawnData> spawnData, Optional<ResourceKey<LootTable>> rewardLootTable) {
        this.detectedPlayers.addAll(players);
        this.currentMobs.addAll(spawnedMobsAlive);
        this.cooldownEndsAt = cooldownEnd;
        this.nextMobSpawnsAt = nextMobSpawnsAt;
        this.totalMobsSpawned = totalSpawnedMobs;
        this.nextSpawnData = spawnData;
        this.ejectingLootTable = rewardLootTable;
    }

    public void reset() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
        this.currentMobs.clear();
    }

    public boolean hasMobToSpawn(TrialSpawner logic, RandomSource random) {
        boolean flag = this.getOrCreateNextSpawnData(logic, random).getEntityToSpawn().contains("id", 8);
        return flag || !logic.getConfig().spawnPotentialsDefinition().isEmpty();
    }

    public boolean hasFinishedSpawningAllMobs(TrialSpawnerConfig config, int additionalPlayers) {
        return this.totalMobsSpawned >= config.calculateTargetTotalMobs(additionalPlayers);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(ServerLevel world, TrialSpawnerConfig config, int additionalPlayers) {
        return world.getGameTime() >= this.nextMobSpawnsAt && this.currentMobs.size() < config.calculateTargetSimultaneousMobs(additionalPlayers);
    }

    public int countAdditionalPlayers(BlockPos pos) {
        if (this.detectedPlayers.isEmpty()) {
            Util.logAndPauseIfInIde("Trial Spawner at " + String.valueOf(pos) + " has no detected players");
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(ServerLevel world, BlockPos pos, TrialSpawner logic) {
        boolean flag;
        boolean bl = flag = (pos.asLong() + world.getGameTime()) % 20L != 0L;
        if (!(flag || logic.getState().equals(TrialSpawnerState.COOLDOWN) && logic.isOminous())) {
            boolean flag1;
            List<UUID> list = logic.getPlayerDetector().detect(world, logic.getEntitySelector(), pos, logic.getRequiredPlayerRange(), true);
            Entity entityhuman = null;
            for (UUID uuid : list) {
                Player entityhuman1 = world.getPlayerByUUID(uuid);
                if (entityhuman1 == null) continue;
                if (entityhuman1.hasEffect(MobEffects.BAD_OMEN)) {
                    this.transformBadOmenIntoTrialOmen(entityhuman1, entityhuman1.getEffect(MobEffects.BAD_OMEN));
                    entityhuman = entityhuman1;
                    continue;
                }
                if (!entityhuman1.hasEffect(MobEffects.TRIAL_OMEN)) continue;
                entityhuman = entityhuman1;
            }
            boolean bl2 = flag1 = !logic.isOminous() && entityhuman != null;
            if (!logic.getState().equals(TrialSpawnerState.COOLDOWN) || flag1) {
                boolean flag2;
                List<UUID> list1;
                if (flag1) {
                    world.levelEvent(3020, BlockPos.containing(entityhuman.getEyePosition()), 0);
                    logic.applyOminous(world, pos);
                }
                List<UUID> list2 = list1 = (flag2 = logic.getData().detectedPlayers.isEmpty()) ? list : logic.getPlayerDetector().detect(world, logic.getEntitySelector(), pos, logic.getRequiredPlayerRange(), false);
                if (this.detectedPlayers.addAll(list1)) {
                    this.nextMobSpawnsAt = Math.max(world.getGameTime() + 40L, this.nextMobSpawnsAt);
                    if (!flag1) {
                        int i = logic.isOminous() ? 3019 : 3013;
                        world.levelEvent(i, pos, this.detectedPlayers.size());
                    }
                }
            }
        }
    }

    public void resetAfterBecomingOminous(TrialSpawner logic, ServerLevel world) {
        Stream stream = this.currentMobs.stream();
        Objects.requireNonNull(world);
        stream.map(world::getEntity).forEach(entity -> {
            if (entity != null) {
                world.levelEvent(3012, entity.blockPosition(), TrialSpawner.FlameParticle.NORMAL.encode());
                entity.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!logic.getOminousConfig().spawnPotentialsDefinition().isEmpty()) {
            this.nextSpawnData = Optional.empty();
        }
        this.totalMobsSpawned = 0;
        this.currentMobs.clear();
        this.nextMobSpawnsAt = world.getGameTime() + (long)logic.getOminousConfig().ticksBetweenSpawn();
        logic.markUpdated();
        this.cooldownEndsAt = world.getGameTime() + logic.getOminousConfig().ticksBetweenItemSpawners();
    }

    private void transformBadOmenIntoTrialOmen(Player player, MobEffectInstance effectInstance) {
        int i = effectInstance.getAmplifier() + 1;
        int j = 18000 * i;
        player.removeEffect(MobEffects.BAD_OMEN);
        player.addEffect(new MobEffectInstance(MobEffects.TRIAL_OMEN, j, 0));
    }

    public boolean isReadyToOpenShutter(ServerLevel world, float f, int i) {
        long j = this.cooldownEndsAt - (long)i;
        return (float)world.getGameTime() >= (float)j + f;
    }

    public boolean isReadyToEjectItems(ServerLevel world, float f, int i) {
        long j = this.cooldownEndsAt - (long)i;
        return (float)(world.getGameTime() - j) % f == 0.0f;
    }

    public boolean isCooldownFinished(ServerLevel world) {
        return world.getGameTime() >= this.cooldownEndsAt;
    }

    public void setEntityId(TrialSpawner logic, RandomSource random, EntityType<?> type) {
        this.getOrCreateNextSpawnData(logic, random).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
    }

    protected SpawnData getOrCreateNextSpawnData(TrialSpawner logic, RandomSource random) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        SimpleWeightedRandomList<SpawnData> simpleweightedrandomlist = logic.getConfig().spawnPotentialsDefinition();
        Optional<SpawnData> optional = simpleweightedrandomlist.isEmpty() ? this.nextSpawnData : simpleweightedrandomlist.getRandom(random).map(WeightedEntry.Wrapper::data);
        this.nextSpawnData = Optional.of(optional.orElseGet(SpawnData::new));
        logic.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(TrialSpawner logic, Level world, TrialSpawnerState state) {
        if (logic.canSpawnInLevel(world) && state.hasSpinningMob()) {
            CompoundTag nbttagcompound;
            if (this.displayEntity == null && (nbttagcompound = this.getOrCreateNextSpawnData(logic, world.getRandom()).getEntityToSpawn()).contains("id", 8)) {
                this.displayEntity = EntityType.loadEntityRecursive(nbttagcompound, world, Function.identity());
            }
            return this.displayEntity;
        }
        return null;
    }

    public CompoundTag getUpdateTag(TrialSpawnerState state) {
        CompoundTag nbttagcompound = new CompoundTag();
        if (state == TrialSpawnerState.ACTIVE) {
            nbttagcompound.putLong(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(mobspawnerdata -> nbttagcompound.put(TAG_SPAWN_DATA, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, mobspawnerdata).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return nbttagcompound;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    SimpleWeightedRandomList<ItemStack> getDispensingItems(ServerLevel world, TrialSpawnerConfig config, BlockPos pos) {
        long i;
        LootParams lootparams;
        if (this.dispensing != null) {
            return this.dispensing;
        }
        LootTable loottable = world.getServer().reloadableRegistries().getLootTable(config.itemsToDropWhenOminous());
        ObjectArrayList<ItemStack> objectarraylist = loottable.getRandomItems(lootparams = new LootParams.Builder(world).create(LootContextParamSets.EMPTY), i = TrialSpawnerData.lowResolutionPosition(world, pos));
        if (objectarraylist.isEmpty()) {
            return SimpleWeightedRandomList.empty();
        }
        SimpleWeightedRandomList.Builder<ItemStack> simpleweightedrandomlist_a = new SimpleWeightedRandomList.Builder<ItemStack>();
        for (ItemStack itemstack : objectarraylist) {
            simpleweightedrandomlist_a.add(itemstack.copyWithCount(1), itemstack.getCount());
        }
        this.dispensing = simpleweightedrandomlist_a.build();
        return this.dispensing;
    }

    private static long lowResolutionPosition(ServerLevel world, BlockPos pos) {
        BlockPos blockposition1 = new BlockPos(Mth.floor((float)pos.getX() / 30.0f), Mth.floor((float)pos.getY() / 20.0f), Mth.floor((float)pos.getZ() / 30.0f));
        return world.getSeed() + blockposition1.asLong();
    }
}

