/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import net.minecraft.world.level.border.WorldBorder;

public interface BorderChangeListener {
    public void onBorderSizeSet(WorldBorder var1, double var2);

    public void onBorderSizeLerping(WorldBorder var1, double var2, double var4, long var6);

    public void onBorderCenterSet(WorldBorder var1, double var2, double var4);

    public void onBorderSetWarningTime(WorldBorder var1, int var2);

    public void onBorderSetWarningBlocks(WorldBorder var1, int var2);

    public void onBorderSetDamagePerBlock(WorldBorder var1, double var2);

    public void onBorderSetDamageSafeZOne(WorldBorder var1, double var2);

    public static class DelegateBorderChangeListener
    implements BorderChangeListener {
        private final WorldBorder worldBorder;

        public DelegateBorderChangeListener(WorldBorder border) {
            this.worldBorder = border;
        }

        @Override
        @Override
        public void onBorderSizeSet(WorldBorder border, double size) {
            this.worldBorder.setSize(size);
        }

        @Override
        @Override
        public void onBorderSizeLerping(WorldBorder border, double fromSize, double toSize, long time) {
            this.worldBorder.lerpSizeBetween(fromSize, toSize, time);
        }

        @Override
        @Override
        public void onBorderCenterSet(WorldBorder border, double centerX, double centerZ) {
            this.worldBorder.setCenter(centerX, centerZ);
        }

        @Override
        @Override
        public void onBorderSetWarningTime(WorldBorder border, int warningTime) {
            this.worldBorder.setWarningTime(warningTime);
        }

        @Override
        @Override
        public void onBorderSetWarningBlocks(WorldBorder border, int warningBlockDistance) {
            this.worldBorder.setWarningBlocks(warningBlockDistance);
        }

        @Override
        @Override
        public void onBorderSetDamagePerBlock(WorldBorder border, double damagePerBlock) {
            this.worldBorder.setDamagePerBlock(damagePerBlock);
        }

        @Override
        @Override
        public void onBorderSetDamageSafeZOne(WorldBorder border, double safeZoneRadius) {
            this.worldBorder.setDamageSafeZone(safeZoneRadius);
        }
    }
}

