/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.destroystokyo.paper.exception.ServerInternalException;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.apache.logging.log4j.LogManager;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.region.AbstractRegionFile;
import org.leavesmc.leaves.region.AbstractRegionFileFactory;
import org.leavesmc.leaves.region.LinearRegionFile;
import org.leavesmc.leaves.region.RegionFileFormat;

public class RegionFileStorage
implements AutoCloseable {
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<AbstractRegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;
    private final boolean isChunkData;
    public final RegionFileFormat format;
    public final int linearCompression;
    static final int MAX_NON_EXISTING_CACHE = 65536;
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    private synchronized boolean doesRegionFilePossiblyExist(long position) {
        if (this.nonExistingRegionFiles.contains(position)) {
            this.nonExistingRegionFiles.addAndMoveToFirst(position);
            return false;
        }
        return true;
    }

    private synchronized void createRegionFile(long position) {
        this.nonExistingRegionFiles.remove(position);
    }

    private synchronized void markNonExisting(long position) {
        if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
            while (this.nonExistingRegionFiles.size() >= 65536) {
                this.nonExistingRegionFiles.removeLastLong();
            }
        }
    }

    public synchronized boolean doesRegionFileNotExistNoIO(ChunkPos pos) {
        long key = ChunkPos.asLong(pos.getRegionX(), pos.getRegionZ());
        return !this.doesRegionFilePossiblyExist(key);
    }

    protected RegionFileStorage(RegionStorageInfo storageKey, Path directory, boolean dsync) {
        this(storageKey, directory, dsync, false);
    }

    RegionFileStorage(RegionStorageInfo storageKey, Path directory, boolean dsync, boolean isChunkData) {
        this.isChunkData = isChunkData;
        this.folder = directory;
        this.sync = dsync;
        this.info = storageKey;
        this.format = LeavesConfig.regionFormatName;
        this.linearCompression = LeavesConfig.linearCompressionLevel;
    }

    @Nullable
    public static ChunkPos getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!(fileName.startsWith("r.") && fileName.endsWith(ANVIL_EXTENSION) && fileName.endsWith(".linear"))) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(split[1]);
            int z = Integer.parseInt(split[2]);
            return new ChunkPos(x << 5, z << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public synchronized AbstractRegionFile getRegionFileIfLoaded(ChunkPos chunkcoordintpair) {
        return (AbstractRegionFile)this.regionCache.getAndMoveToFirst(ChunkPos.asLong(chunkcoordintpair.getRegionX(), chunkcoordintpair.getRegionZ()));
    }

    public synchronized boolean chunkExists(ChunkPos pos) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, true);
        return regionfile != null ? regionfile.hasChunk(pos) : false;
    }

    public synchronized AbstractRegionFile getRegionFile(ChunkPos chunkcoordintpair, boolean existingOnly) throws IOException {
        return this.getRegionFile(chunkcoordintpair, existingOnly, false);
    }

    public synchronized AbstractRegionFile getRegionFile(ChunkPos chunkcoordintpair, boolean existingOnly, boolean lock) throws IOException {
        Path path1;
        long i;
        long regionPos = i = ChunkPos.asLong(chunkcoordintpair.getRegionX(), chunkcoordintpair.getRegionZ());
        AbstractRegionFile regionfile = (AbstractRegionFile)this.regionCache.getAndMoveToFirst(i);
        if (regionfile != null) {
            if (lock) {
                regionfile.getFileLock().lock();
            }
            return regionfile;
        }
        if (existingOnly && !this.doesRegionFilePossiblyExist(regionPos)) {
            return null;
        }
        if (this.regionCache.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
            ((AbstractRegionFile)this.regionCache.removeLast()).close();
        }
        Path path = this.folder;
        int j = chunkcoordintpair.getRegionX();
        if (existingOnly) {
            Path anvil = path.resolve("r." + j + "." + chunkcoordintpair.getRegionZ() + ANVIL_EXTENSION);
            Path linear = path.resolve("r." + j + "." + chunkcoordintpair.getRegionZ() + ".linear");
            Path path2 = Files.exists(linear, new LinkOption[0]) ? linear : (path1 = Files.exists(anvil, new LinkOption[0]) ? anvil : null);
            if (path1 == null) {
                this.markNonExisting(regionPos);
                return null;
            }
        } else {
            String extension = switch (this.format) {
                case RegionFileFormat.LINEAR -> "linear";
                default -> "mca";
            };
            path1 = path.resolve("r." + j + "." + chunkcoordintpair.getRegionZ() + "." + extension);
            this.createRegionFile(regionPos);
        }
        FileUtil.createDirectoriesSafe(this.folder);
        AbstractRegionFile regionfile1 = AbstractRegionFileFactory.getAbstractRegionFile(this.linearCompression, this.info, path1, this.folder, this.sync, this.isChunkData);
        this.regionCache.putAndMoveToFirst(i, (Object)regionfile1);
        if (lock) {
            regionfile1.getFileLock().lock();
        }
        return regionfile1;
    }

    private static void printOversizedLog(String msg, Path file, int x, int z) {
        LogManager.getLogger().fatal(msg + " (" + file.toString().replaceAll(".+[\\\\/]", "") + " - " + x + "," + z + ") Go clean it up to remove this message. /minecraft:tp " + (x << 4) + " 128 " + (z << 4) + " - DO NOT REPORT THIS TO PAPER - You may ask for help on Discord, but do not file an issue. These error messages can not be removed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompoundTag readOversizedChunk(AbstractRegionFile regionfile, ChunkPos chunkCoordinate) throws IOException {
        AbstractRegionFile abstractRegionFile = regionfile;
        synchronized (abstractRegionFile) {
            try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkCoordinate);){
                CompoundTag oversizedData = regionfile.getOversizedData(chunkCoordinate.x, chunkCoordinate.z);
                CompoundTag chunk = NbtIo.read(datainputstream);
                if (oversizedData == null) {
                    CompoundTag compoundTag2 = chunk;
                    return compoundTag2;
                }
                CompoundTag oversizedLevel = oversizedData.getCompound("Level");
                RegionFileStorage.mergeChunkList(chunk.getCompound("Level"), oversizedLevel, "Entities", "Entities");
                RegionFileStorage.mergeChunkList(chunk.getCompound("Level"), oversizedLevel, "TileEntities", "TileEntities");
                CompoundTag compoundTag = chunk;
                return compoundTag;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable3;
            }
        }
    }

    private static void mergeChunkList(CompoundTag level, CompoundTag oversizedLevel, String key, String oversizedKey) {
        ListTag levelList = level.getList(key, 10);
        ListTag oversizedList = oversizedLevel.getList(oversizedKey, 10);
        if (!oversizedList.isEmpty()) {
            levelList.addAll(oversizedList);
            level.put(key, levelList);
        }
    }

    @Nullable
    public CompoundTag read(ChunkPos pos) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, true, true);
        if (regionfile == null) {
            return null;
        }
        return this.read(pos, regionfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag read(ChunkPos pos, AbstractRegionFile regionfile) throws IOException {
        try {
            CompoundTag nbttagcompound;
            DataInputStream datainputstream = regionfile.getChunkDataInputStream(pos);
            if (regionfile.isOversized(pos.x, pos.z)) {
                RegionFileStorage.printOversizedLog("Loading Oversized Chunk!", regionfile.getRegionFile(), pos.x, pos.z);
                CompoundTag compoundTag = RegionFileStorage.readOversizedChunk(regionfile, pos);
                return compoundTag;
            }
            if (datainputstream != null) {
                ChunkPos chunkPos;
                nbttagcompound = NbtIo.read(datainputstream);
                if (this.isChunkData && !(chunkPos = ChunkSerializer.getChunkCoordinate(nbttagcompound)).equals(pos)) {
                    MinecraftServer.LOGGER.error("Attempting to read chunk data at " + String.valueOf(pos) + " but got chunk data for " + String.valueOf(chunkPos) + " instead! Attempting regionfile recalculation for regionfile " + String.valueOf(regionfile.getRegionFile().toAbsolutePath()));
                    if (regionfile.recalculateHeader()) {
                        regionfile.getFileLock().lock();
                        CompoundTag compoundTag = this.read(pos, regionfile);
                        return compoundTag;
                    }
                    MinecraftServer.LOGGER.error("Can't recalculate regionfile header, regenerating chunk " + String.valueOf(pos) + " for " + String.valueOf(regionfile.getRegionFile().toAbsolutePath()));
                    CompoundTag compoundTag = null;
                    return compoundTag;
                }
            } else {
                CompoundTag nbttagcompound2;
                try {
                    nbttagcompound2 = null;
                }
                finally {
                    if (datainputstream != null) {
                        datainputstream.close();
                    }
                }
                CompoundTag compoundTag = nbttagcompound2;
                return compoundTag;
            }
            if (datainputstream != null) {
                datainputstream.close();
            }
            CompoundTag compoundTag = nbttagcompound;
            return compoundTag;
        }
        finally {
            regionfile.getFileLock().unlock();
        }
    }

    public void scanChunk(ChunkPos chunkPos, StreamTagVisitor scanner) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(chunkPos, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkPos);){
            if (datainputstream != null) {
                NbtIo.parse(datainputstream, scanner, NbtAccounter.unlimitedHeap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void write(ChunkPos pos, @Nullable CompoundTag nbt) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, nbt == null, true);
        if (nbt == null && regionfile == null) {
            return;
        }
        int attempts = 0;
        Exception lastException = null;
        while (attempts++ < 5) {
            try {
                DataOutputStream dataoutputstream;
                block27: {
                    if (nbt == null) {
                        regionfile.clear(pos);
                        return;
                    }
                    if (regionfile instanceof RegionFile && LeavesConfig.regionFormatName == RegionFileFormat.LINEAR && LeavesConfig.autoConvertAnvilToLinear) {
                        Path linearFilePath = Path.of(regionfile.getRegionFile().toString().replaceAll(ANVIL_EXTENSION, ".linear"), new String[0]);
                        LinearRegionFile linearRegionFile = new LinearRegionFile(linearFilePath, LeavesConfig.linearCompressionLevel);
                        try {
                            DataInputStream regionDataInputStream = regionfile.getChunkDataInputStream(pos);
                            if (regionDataInputStream == null) continue;
                            CompoundTag compoundTag = NbtIo.read(regionDataInputStream);
                            try (DataOutputStream linearDataOutputStream = linearRegionFile.getChunkDataOutputStream(pos);){
                                NbtIo.write(compoundTag, linearDataOutputStream);
                            }
                            linearRegionFile.flush();
                            if (Files.isRegularFile(regionfile.getRegionFile(), new LinkOption[0])) {
                                Files.delete(regionfile.getRegionFile());
                            }
                            dataoutputstream = linearRegionFile.getChunkDataOutputStream(pos);
                            break block27;
                        }
                        finally {
                            linearRegionFile.close();
                            continue;
                        }
                    }
                    dataoutputstream = regionfile.getChunkDataOutputStream(pos);
                }
                try {
                    NbtIo.write(nbt, dataoutputstream);
                    regionfile.setStatus(pos.x, pos.z, ChunkSerializer.getStatus(nbt));
                    regionfile.setOversized(pos.x, pos.z, false);
                    dataoutputstream.close();
                    return;
                }
                catch (RegionFileSizeException e) {
                    attempts = 5;
                    regionfile.clear(pos);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (dataoutputstream == null) throw throwable;
                    throw throwable;
                }
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (lastException == null) return;
        ServerInternalException.reportInternalException(lastException);
        MinecraftServer.LOGGER.error("Failed to save chunk {}", (Object)pos, (Object)lastException);
        return;
        finally {
            regionfile.getFileLock().unlock();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        ExceptionCollector<IOException> exceptionsuppressor = new ExceptionCollector<IOException>();
        for (AbstractRegionFile regionfile : this.regionCache.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptionsuppressor.add(ioexception);
            }
        }
        exceptionsuppressor.throwIfPresent();
    }

    public synchronized void flush() throws IOException {
        for (AbstractRegionFile regionfile : this.regionCache.values()) {
            regionfile.flush();
        }
    }

    public static final class RegionFileSizeException
    extends RuntimeException {
        public RegionFileSizeException(String message) {
            super(message);
        }
    }
}

