/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;

public class EntityTickList {
    private final IteratorSafeOrderedReferenceSet<Entity> entities = new IteratorSafeOrderedReferenceSet(true);

    private void ensureActiveIsNotIterated() {
    }

    public void add(Entity entity) {
        TickThread.ensureTickThread("Asynchronous entity ticklist addition");
        this.ensureActiveIsNotIterated();
        this.entities.add(entity);
    }

    public void remove(Entity entity) {
        TickThread.ensureTickThread("Asynchronous entity ticklist removal");
        this.ensureActiveIsNotIterated();
        this.entities.remove(entity);
    }

    public boolean contains(Entity entity) {
        return this.entities.contains(entity);
    }

    public void forEach(Consumer<Entity> action) {
        TickThread.ensureTickThread("Asynchronous entity ticklist iteration");
        IteratorSafeOrderedReferenceSet.Iterator<Entity> iterator = this.entities.iterator();
        try {
            while (iterator.hasNext()) {
                action.accept((Entity)iterator.next());
            }
        }
        finally {
            iterator.finishedIterating();
        }
    }
}

