/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;

public class LevelEntityGetterAdapter<T extends EntityAccess>
implements LevelEntityGetter<T> {
    private final EntityLookup<T> visibleEntities;
    private final EntitySectionStorage<T> sectionStorage;

    public LevelEntityGetterAdapter(EntityLookup<T> index, EntitySectionStorage<T> cache) {
        this.visibleEntities = index;
        this.sectionStorage = cache;
    }

    @Override
    @Nullable
    @Override
    public T get(int id) {
        return this.visibleEntities.getEntity(id);
    }

    @Override
    @Nullable
    @Override
    public T get(UUID uuid) {
        return this.visibleEntities.getEntity(uuid);
    }

    @Override
    @Override
    public Iterable<T> getAll() {
        return this.visibleEntities.getAllEntities();
    }

    @Override
    @Override
    public <U extends T> void get(EntityTypeTest<T, U> filter, AbortableIterationConsumer<U> consumer) {
        this.visibleEntities.getEntities(filter, consumer);
    }

    @Override
    @Override
    public void get(AABB box, Consumer<T> action) {
        this.sectionStorage.getEntities(box, AbortableIterationConsumer.forConsumer(action));
    }

    @Override
    @Override
    public <U extends T> void get(EntityTypeTest<T, U> filter, AABB box, AbortableIterationConsumer<U> consumer) {
        this.sectionStorage.getEntities(filter, box, consumer);
    }
}

