/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PatrolSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        int patrolSpawnDelay;
        if (world.paperConfig().entities.behavior.pillagerPatrols.disable || world.paperConfig().entities.behavior.pillagerPatrols.spawnChance == 0.0) {
            return 0;
        }
        if (!spawnMonsters) {
            return 0;
        }
        if (!world.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return 0;
        }
        RandomSource randomsource = world.random;
        int j = world.players().size();
        if (j < 1) {
            return 0;
        }
        ServerPlayer entityhuman = world.players().get(randomsource.nextInt(j));
        if (entityhuman.isSpectator()) {
            return 0;
        }
        if (world.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            --entityhuman.patrolSpawnDelay;
            patrolSpawnDelay = entityhuman.patrolSpawnDelay;
        } else {
            --this.nextTick;
            patrolSpawnDelay = this.nextTick;
        }
        if (patrolSpawnDelay > 0) {
            return 0;
        }
        long days = world.paperConfig().entities.behavior.pillagerPatrols.start.perPlayer ? (long)entityhuman.getStats().getValue(Stats.CUSTOM.get(Stats.PLAY_TIME)) / 24000L : world.getDayTime() / 24000L;
        if (world.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            entityhuman.patrolSpawnDelay += world.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomsource.nextInt(1200);
        } else {
            this.nextTick += world.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomsource.nextInt(1200);
        }
        if (days >= (long)world.paperConfig().entities.behavior.pillagerPatrols.start.day && world.isDay()) {
            if (randomsource.nextDouble() >= world.paperConfig().entities.behavior.pillagerPatrols.spawnChance) {
                return 0;
            }
            if (j < 1) {
                return 0;
            }
            if (entityhuman.isSpectator()) {
                return 0;
            }
            if (world.isCloseToVillage(entityhuman.blockPosition(), 2)) {
                return 0;
            }
            int k = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
            int l = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
            BlockPos.MutableBlockPos blockposition_mutableblockposition = entityhuman.blockPosition().mutable().move(k, 0, l);
            boolean flag2 = true;
            if (!world.hasChunksAt(blockposition_mutableblockposition.getX() - 10, blockposition_mutableblockposition.getZ() - 10, blockposition_mutableblockposition.getX() + 10, blockposition_mutableblockposition.getZ() + 10)) {
                return 0;
            }
            Holder<Biome> holder = world.getBiome(blockposition_mutableblockposition);
            if (holder.is(BiomeTags.WITHOUT_PATROL_SPAWNS)) {
                return 0;
            }
            int i1 = 0;
            int j1 = (int)Math.ceil(world.getCurrentDifficultyAt(blockposition_mutableblockposition).getEffectiveDifficulty()) + 1;
            for (int k1 = 0; k1 < j1; ++k1) {
                ++i1;
                blockposition_mutableblockposition.setY(world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockposition_mutableblockposition).getY());
                if (k1 == 0) {
                    if (!this.spawnPatrolMember(world, blockposition_mutableblockposition, randomsource, true)) {
                        break;
                    }
                } else {
                    this.spawnPatrolMember(world, blockposition_mutableblockposition, randomsource, false);
                }
                blockposition_mutableblockposition.setX(blockposition_mutableblockposition.getX() + randomsource.nextInt(5) - randomsource.nextInt(5));
                blockposition_mutableblockposition.setZ(blockposition_mutableblockposition.getZ() + randomsource.nextInt(5) - randomsource.nextInt(5));
            }
            return i1;
        }
        return 0;
    }

    private boolean spawnPatrolMember(ServerLevel world, BlockPos pos, RandomSource random, boolean captain) {
        BlockState iblockdata = world.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock(world, pos, iblockdata, iblockdata.getFluidState(), EntityType.PILLAGER)) {
            return false;
        }
        if (!PatrollingMonster.checkPatrollingMonsterSpawnRules(EntityType.PILLAGER, world, MobSpawnType.PATROL, pos, random)) {
            return false;
        }
        PatrollingMonster entitymonsterpatrolling = EntityType.PILLAGER.create(world);
        if (entitymonsterpatrolling != null) {
            if (captain) {
                entitymonsterpatrolling.setPatrolLeader(true);
                entitymonsterpatrolling.findPatrolTarget();
            }
            entitymonsterpatrolling.setPos(pos.getX(), pos.getY(), pos.getZ());
            entitymonsterpatrolling.finalizeSpawn(world, world.getCurrentDifficultyAt(pos), MobSpawnType.PATROL, null);
            world.addFreshEntityWithPassengers(entitymonsterpatrolling, CreatureSpawnEvent.SpawnReason.PATROL);
            return true;
        }
        return false;
    }
}

