/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.NetherWorldCarver;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldCarver<C extends CarverConfiguration> {
    public static final WorldCarver<CaveCarverConfiguration> CAVE = WorldCarver.register("cave", new CaveWorldCarver(CaveCarverConfiguration.CODEC));
    public static final WorldCarver<CaveCarverConfiguration> NETHER_CAVE = WorldCarver.register("nether_cave", new NetherWorldCarver(CaveCarverConfiguration.CODEC));
    public static final WorldCarver<CanyonCarverConfiguration> CANYON = WorldCarver.register("canyon", new CanyonWorldCarver(CanyonCarverConfiguration.CODEC));
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected static final FluidState WATER = Fluids.WATER.defaultFluidState();
    protected static final FluidState LAVA = Fluids.LAVA.defaultFluidState();
    protected Set<Fluid> liquids = ImmutableSet.of((Object)Fluids.WATER);
    private final MapCodec<ConfiguredWorldCarver<C>> configuredCodec;

    private static <C extends CarverConfiguration, F extends WorldCarver<C>> F register(String name, F carver) {
        return (F)Registry.register(BuiltInRegistries.CARVER, name, carver);
    }

    public WorldCarver(Codec<C> configCodec) {
        this.configuredCodec = configCodec.fieldOf("config").xmap(this::configured, ConfiguredWorldCarver::config);
    }

    public ConfiguredWorldCarver<C> configured(C config) {
        return new ConfiguredWorldCarver<C>(this, config);
    }

    public MapCodec<ConfiguredWorldCarver<C>> configuredCodec() {
        return this.configuredCodec;
    }

    public int getRange() {
        return 4;
    }

    protected boolean carveEllipsoid(CarvingContext context, C config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, Aquifer aquiferSampler, double x, double y, double z, double width, double height, CarvingMask mask, CarveSkipChecker skipPredicate) {
        ChunkPos chunkPos = chunk.getPos();
        double d = chunkPos.getMiddleBlockX();
        double e = chunkPos.getMiddleBlockZ();
        double f = 16.0 + width * 2.0;
        if (Math.abs(x - d) > f || Math.abs(z - e) > f) {
            return false;
        }
        int i = chunkPos.getMinBlockX();
        int j = chunkPos.getMinBlockZ();
        int k = Math.max(Mth.floor(x - width) - i - 1, 0);
        int l = Math.min(Mth.floor(x + width) - i, 15);
        int m = Math.max(Mth.floor(y - height) - 1, context.getMinGenY() + 1);
        int n = chunk.isUpgrading() ? 0 : 7;
        int o = Math.min(Mth.floor(y + height) + 1, context.getMinGenY() + context.getGenDepth() - 1 - n);
        int p = Math.max(Mth.floor(z - width) - j - 1, 0);
        int q = Math.min(Mth.floor(z + width) - j, 15);
        boolean bl = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
        for (int r = k; r <= l; ++r) {
            int s = chunkPos.getBlockX(r);
            double g = ((double)s + 0.5 - x) / width;
            for (int t = p; t <= q; ++t) {
                int u = chunkPos.getBlockZ(t);
                double h = ((double)u + 0.5 - z) / width;
                if (g * g + h * h >= 1.0) continue;
                MutableBoolean mutableBoolean = new MutableBoolean(false);
                for (int v = o; v > m; --v) {
                    double w = ((double)v - 0.5 - y) / height;
                    if (skipPredicate.shouldSkip(context, g, w, h, v) || mask.get(r, v, t) && !WorldCarver.isDebugEnabled(config)) continue;
                    mask.set(r, v, t);
                    mutableBlockPos.set(s, v, u);
                    bl |= this.carveBlock(context, config, chunk, posToBiome, mask, mutableBlockPos, mutableBlockPos2, aquiferSampler, mutableBoolean);
                }
            }
        }
        return bl;
    }

    protected boolean carveBlock(CarvingContext context, C config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        BlockState blockState = chunk.getBlockState(pos);
        if (blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.MYCELIUM)) {
            replacedGrassy.setTrue();
        }
        if (!this.canReplaceBlock(config, blockState) && !WorldCarver.isDebugEnabled(config)) {
            return false;
        }
        BlockState blockState2 = this.getCarveState(context, config, pos, aquiferSampler);
        if (blockState2 == null) {
            return false;
        }
        chunk.setBlockState(pos, blockState2, false);
        if (aquiferSampler.shouldScheduleFluidUpdate() && !blockState2.getFluidState().isEmpty()) {
            chunk.markPosForPostprocessing(pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.setWithOffset((Vec3i)pos, Direction.DOWN);
            if (chunk.getBlockState(tmp).is(Blocks.DIRT)) {
                context.topMaterial(posToBiome, chunk, tmp, !blockState2.getFluidState().isEmpty()).ifPresent(state -> {
                    chunk.setBlockState(tmp, (BlockState)state, false);
                    if (!state.getFluidState().isEmpty()) {
                        chunk.markPosForPostprocessing(tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getCarveState(CarvingContext context, C config, BlockPos pos, Aquifer sampler) {
        if (pos.getY() <= ((CarverConfiguration)config).lavaLevel.resolveY(context)) {
            return LAVA.createLegacyBlock();
        }
        BlockState blockState = sampler.computeSubstance(new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()), 0.0);
        if (blockState == null) {
            return WorldCarver.isDebugEnabled(config) ? ((CarverConfiguration)config).debugSettings.getBarrierState() : null;
        }
        return WorldCarver.isDebugEnabled(config) ? WorldCarver.getDebugState(config, blockState) : blockState;
    }

    private static BlockState getDebugState(CarverConfiguration config, BlockState state) {
        if (state.is(Blocks.AIR)) {
            return config.debugSettings.getAirState();
        }
        if (state.is(Blocks.WATER)) {
            BlockState blockState = config.debugSettings.getWaterState();
            if (blockState.hasProperty(BlockStateProperties.WATERLOGGED)) {
                return (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, true);
            }
            return blockState;
        }
        if (state.is(Blocks.LAVA)) {
            return config.debugSettings.getLavaState();
        }
        return state;
    }

    public abstract boolean carve(CarvingContext var1, C var2, ChunkAccess var3, Function<BlockPos, Holder<Biome>> var4, RandomSource var5, Aquifer var6, ChunkPos var7, CarvingMask var8);

    public abstract boolean isStartChunk(C var1, RandomSource var2);

    protected boolean canReplaceBlock(C config, BlockState state) {
        return state.is(((CarverConfiguration)config).replaceable);
    }

    protected static boolean canReach(ChunkPos pos, double x, double z, int branchIndex, int branchCount, float baseWidth) {
        double i;
        double h;
        double e;
        double g;
        double d = pos.getMiddleBlockX();
        double f = x - d;
        return f * f + (g = z - (e = (double)pos.getMiddleBlockZ())) * g - (h = (double)(branchCount - branchIndex)) * h <= (i = (double)(baseWidth + 2.0f + 16.0f)) * i;
    }

    private static boolean isDebugEnabled(CarverConfiguration config) {
        return config.debugSettings.isDebugMode();
    }

    public static interface CarveSkipChecker {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

