/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CarvingMaskPlacement
extends PlacementModifier {
    public static final MapCodec<CarvingMaskPlacement> CODEC = GenerationStep.Carving.CODEC.fieldOf("step").xmap(CarvingMaskPlacement::new, config -> config.step);
    private final GenerationStep.Carving step;

    private CarvingMaskPlacement(GenerationStep.Carving step) {
        this.step = step;
    }

    public static CarvingMaskPlacement forStep(GenerationStep.Carving step) {
        return new CarvingMaskPlacement(step);
    }

    @Override
    @Override
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return context.getCarvingMask(chunkPos, this.step).stream(chunkPos);
    }

    @Override
    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.CARVING_MASK_PLACEMENT;
    }
}

