/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.leavesmc.leaves.LeavesConfig;

public final class ImprovedNoise {
    private static final float SHIFT_UP_EPSILON = 1.0E-7f;
    private final byte[] p;
    public final double xo;
    public final double yo;
    public final double zo;
    private static final double[] FLAT_SIMPLEX_GRAD = new double[]{1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0};

    public ImprovedNoise(RandomSource random) {
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        this.p = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.p[i] = (byte)i;
        }
        for (int j = 0; j < 256; ++j) {
            int k = random.nextInt(256 - j);
            byte b = this.p[j];
            this.p[j] = this.p[j + k];
            this.p[j + k] = b;
        }
    }

    public double noise(double x, double y, double z) {
        return this.noise(x, y, z, 0.0, 0.0);
    }

    @Deprecated
    public double noise(double x, double y, double z, double yScale, double yMax) {
        double o;
        double l;
        double h;
        double g;
        double d = x + this.xo;
        double e = y + this.yo;
        double f = z + this.zo;
        int i = Mth.floor(d);
        int j = Mth.floor(e);
        int k = Mth.floor(f);
        if (!LeavesConfig.optimizeNoiseGeneration) {
            g = d - (double)i;
            h = e - (double)j;
            l = f - (double)k;
        } else {
            g = d - (double)i;
            h = e - (double)j;
            l = f - (double)k;
        }
        if (yScale != 0.0) {
            double m = yMax >= 0.0 && yMax < h ? yMax : h;
            o = !LeavesConfig.optimizeNoiseGeneration ? (double)Mth.floor(m / yScale + (double)1.0E-7f) * yScale : Math.floor(m / yScale + (double)1.0E-7f) * yScale;
        } else {
            o = 0.0;
        }
        if (!LeavesConfig.optimizeNoiseGeneration) {
            return this.sampleAndLerp(i, j, k, g, h - o, l, h);
        }
        return this.sampleAndLerp(i, j, k, g, h - o, l, h);
    }

    public double noiseWithDerivative(double x, double y, double z, double[] ds) {
        double d = x + this.xo;
        double e = y + this.yo;
        double f = z + this.zo;
        int i = Mth.floor(d);
        int j = Mth.floor(e);
        int k = Mth.floor(f);
        if (!LeavesConfig.optimizeNoiseGeneration) {
            double g = d - (double)i;
            double h = e - (double)j;
            double l = f - (double)k;
            return this.sampleWithDerivative(i, j, k, g, h, l, ds);
        }
        double g = d - (double)i;
        double h = e - (double)j;
        double l = f - (double)k;
        return this.sampleWithDerivative(i, j, k, g, h, l, ds);
    }

    private static double gradDot(int hash, double x, double y, double z) {
        return SimplexNoise.dot(SimplexNoise.GRADIENT[hash & 0xF], x, y, z);
    }

    private int p(int input) {
        return this.p[input & 0xFF] & 0xFF;
    }

    private double sampleAndLerp(int sectionX, int sectionY, int sectionZ, double localX, double localY, double localZ, double fadeLocalY) {
        if (!LeavesConfig.optimizeNoiseGeneration) {
            int i = this.p(sectionX);
            int j = this.p(sectionX + 1);
            int k = this.p(i + sectionY);
            int l = this.p(i + sectionY + 1);
            int m = this.p(j + sectionY);
            int n = this.p(j + sectionY + 1);
            double d = ImprovedNoise.gradDot(this.p(k + sectionZ), localX, localY, localZ);
            double e = ImprovedNoise.gradDot(this.p(m + sectionZ), localX - 1.0, localY, localZ);
            double f = ImprovedNoise.gradDot(this.p(l + sectionZ), localX, localY - 1.0, localZ);
            double g = ImprovedNoise.gradDot(this.p(n + sectionZ), localX - 1.0, localY - 1.0, localZ);
            double h = ImprovedNoise.gradDot(this.p(k + sectionZ + 1), localX, localY, localZ - 1.0);
            double o = ImprovedNoise.gradDot(this.p(m + sectionZ + 1), localX - 1.0, localY, localZ - 1.0);
            double p = ImprovedNoise.gradDot(this.p(l + sectionZ + 1), localX, localY - 1.0, localZ - 1.0);
            double q = ImprovedNoise.gradDot(this.p(n + sectionZ + 1), localX - 1.0, localY - 1.0, localZ - 1.0);
            double r = Mth.smoothstep(localX);
            double s = Mth.smoothstep(fadeLocalY);
            double t = Mth.smoothstep(localZ);
            return Mth.lerp3(r, s, t, d, e, f, g, h, o, p, q);
        }
        int var0 = sectionX & 0xFF;
        int var1 = sectionX + 1 & 0xFF;
        int var2 = this.p[var0] & 0xFF;
        int var3 = this.p[var1] & 0xFF;
        int var4 = var2 + sectionY & 0xFF;
        int var5 = var3 + sectionY & 0xFF;
        int var6 = var2 + sectionY + 1 & 0xFF;
        int var7 = var3 + sectionY + 1 & 0xFF;
        int var8 = this.p[var4] & 0xFF;
        int var9 = this.p[var5] & 0xFF;
        int var10 = this.p[var6] & 0xFF;
        int var11 = this.p[var7] & 0xFF;
        int var12 = var8 + sectionZ & 0xFF;
        int var13 = var9 + sectionZ & 0xFF;
        int var14 = var10 + sectionZ & 0xFF;
        int var15 = var11 + sectionZ & 0xFF;
        int var16 = var8 + sectionZ + 1 & 0xFF;
        int var17 = var9 + sectionZ + 1 & 0xFF;
        int var18 = var10 + sectionZ + 1 & 0xFF;
        int var19 = var11 + sectionZ + 1 & 0xFF;
        int var20 = (this.p[var12] & 0xF) << 2;
        int var21 = (this.p[var13] & 0xF) << 2;
        int var22 = (this.p[var14] & 0xF) << 2;
        int var23 = (this.p[var15] & 0xF) << 2;
        int var24 = (this.p[var16] & 0xF) << 2;
        int var25 = (this.p[var17] & 0xF) << 2;
        int var26 = (this.p[var18] & 0xF) << 2;
        int var27 = (this.p[var19] & 0xF) << 2;
        double var60 = localX - 1.0;
        double var61 = localY - 1.0;
        double var62 = localZ - 1.0;
        double var87 = FLAT_SIMPLEX_GRAD[var20 | 0] * localX + FLAT_SIMPLEX_GRAD[var20 | 1] * localY + FLAT_SIMPLEX_GRAD[var20 | 2] * localZ;
        double var88 = FLAT_SIMPLEX_GRAD[var21 | 0] * var60 + FLAT_SIMPLEX_GRAD[var21 | 1] * localY + FLAT_SIMPLEX_GRAD[var21 | 2] * localZ;
        double var89 = FLAT_SIMPLEX_GRAD[var22 | 0] * localX + FLAT_SIMPLEX_GRAD[var22 | 1] * var61 + FLAT_SIMPLEX_GRAD[var22 | 2] * localZ;
        double var90 = FLAT_SIMPLEX_GRAD[var23 | 0] * var60 + FLAT_SIMPLEX_GRAD[var23 | 1] * var61 + FLAT_SIMPLEX_GRAD[var23 | 2] * localZ;
        double var91 = FLAT_SIMPLEX_GRAD[var24 | 0] * localX + FLAT_SIMPLEX_GRAD[var24 | 1] * localY + FLAT_SIMPLEX_GRAD[var24 | 2] * var62;
        double var92 = FLAT_SIMPLEX_GRAD[var25 | 0] * var60 + FLAT_SIMPLEX_GRAD[var25 | 1] * localY + FLAT_SIMPLEX_GRAD[var25 | 2] * var62;
        double var93 = FLAT_SIMPLEX_GRAD[var26 | 0] * localX + FLAT_SIMPLEX_GRAD[var26 | 1] * var61 + FLAT_SIMPLEX_GRAD[var26 | 2] * var62;
        double var94 = FLAT_SIMPLEX_GRAD[var27 | 0] * var60 + FLAT_SIMPLEX_GRAD[var27 | 1] * var61 + FLAT_SIMPLEX_GRAD[var27 | 2] * var62;
        double var95 = localX * 6.0 - 15.0;
        double var96 = fadeLocalY * 6.0 - 15.0;
        double var97 = localZ * 6.0 - 15.0;
        double var98 = localX * var95 + 10.0;
        double var99 = fadeLocalY * var96 + 10.0;
        double var100 = localZ * var97 + 10.0;
        double var101 = localX * localX * localX * var98;
        double var102 = fadeLocalY * fadeLocalY * fadeLocalY * var99;
        double var103 = localZ * localZ * localZ * var100;
        double var113 = var87 + var101 * (var88 - var87);
        double var114 = var93 + var101 * (var94 - var93);
        double var115 = var91 + var101 * (var92 - var91);
        double var116 = var89 + var101 * (var90 - var89);
        double var117 = var114 - var115;
        double var118 = var102 * (var116 - var113);
        double var119 = var102 * var117;
        double var120 = var113 + var118;
        double var121 = var115 + var119;
        return var120 + var103 * (var121 - var120);
    }

    private double sampleWithDerivative(int sectionX, int sectionY, int sectionZ, double localX, double localY, double localZ, double[] ds) {
        int i = this.p(sectionX);
        int j = this.p(sectionX + 1);
        int k = this.p(i + sectionY);
        int l = this.p(i + sectionY + 1);
        int m = this.p(j + sectionY);
        int n = this.p(j + sectionY + 1);
        int o = this.p(k + sectionZ);
        int p = this.p(m + sectionZ);
        int q = this.p(l + sectionZ);
        int r = this.p(n + sectionZ);
        int s = this.p(k + sectionZ + 1);
        int t = this.p(m + sectionZ + 1);
        int u = this.p(l + sectionZ + 1);
        int v = this.p(n + sectionZ + 1);
        int[] is = SimplexNoise.GRADIENT[o & 0xF];
        int[] js = SimplexNoise.GRADIENT[p & 0xF];
        int[] ks = SimplexNoise.GRADIENT[q & 0xF];
        int[] ls = SimplexNoise.GRADIENT[r & 0xF];
        int[] ms = SimplexNoise.GRADIENT[s & 0xF];
        int[] ns = SimplexNoise.GRADIENT[t & 0xF];
        int[] os = SimplexNoise.GRADIENT[u & 0xF];
        int[] ps = SimplexNoise.GRADIENT[v & 0xF];
        double d = SimplexNoise.dot(is, localX, localY, localZ);
        double e = SimplexNoise.dot(js, localX - 1.0, localY, localZ);
        double f = SimplexNoise.dot(ks, localX, localY - 1.0, localZ);
        double g = SimplexNoise.dot(ls, localX - 1.0, localY - 1.0, localZ);
        double h = SimplexNoise.dot(ms, localX, localY, localZ - 1.0);
        double w = SimplexNoise.dot(ns, localX - 1.0, localY, localZ - 1.0);
        double x = SimplexNoise.dot(os, localX, localY - 1.0, localZ - 1.0);
        double y = SimplexNoise.dot(ps, localX - 1.0, localY - 1.0, localZ - 1.0);
        double z = Mth.smoothstep(localX);
        double aa = Mth.smoothstep(localY);
        double ab = Mth.smoothstep(localZ);
        double ac = Mth.lerp3(z, aa, ab, is[0], js[0], ks[0], ls[0], ms[0], ns[0], os[0], ps[0]);
        double ad = Mth.lerp3(z, aa, ab, is[1], js[1], ks[1], ls[1], ms[1], ns[1], os[1], ps[1]);
        double ae = Mth.lerp3(z, aa, ab, is[2], js[2], ks[2], ls[2], ms[2], ns[2], os[2], ps[2]);
        double af = Mth.lerp2(aa, ab, e - d, g - f, w - h, y - x);
        double ag = Mth.lerp2(ab, z, f - d, x - h, g - e, y - w);
        double ah = Mth.lerp2(z, aa, h - d, w - e, x - f, y - g);
        double ai = Mth.smoothstepDerivative(localX);
        double aj = Mth.smoothstepDerivative(localY);
        double ak = Mth.smoothstepDerivative(localZ);
        double al = ac + ai * af;
        double am = ad + aj * ag;
        double an = ae + ak * ah;
        ds[0] = ds[0] + al;
        ds[1] = ds[1] + am;
        ds[2] = ds[2] + an;
        return Mth.lerp3(z, aa, ab, d, e, f, g, h, w, x, y);
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder info) {
        NoiseUtils.parityNoiseOctaveConfigString(info, this.xo, this.yo, this.zo, this.p);
    }
}

