/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class AmphibiousNodeEvaluator
extends WalkNodeEvaluator {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;

    public AmphibiousNodeEvaluator(boolean penalizeDeepWater) {
        this.prefersShallowSwimming = penalizeDeepWater;
    }

    @Override
    @Override
    public void prepare(PathNavigationRegion cachedWorld, Mob entity) {
        super.prepare(cachedWorld, entity);
        entity.setPathfindingMalus(PathType.WATER, 0.0f);
        this.oldWalkableCost = entity.getPathfindingMalus(PathType.WALKABLE);
        entity.setPathfindingMalus(PathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = entity.getPathfindingMalus(PathType.WATER_BORDER);
        entity.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    @Override
    @Override
    public void done() {
        this.mob.setPathfindingMalus(PathType.WALKABLE, this.oldWalkableCost);
        this.mob.setPathfindingMalus(PathType.WATER_BORDER, this.oldWaterBorderCost);
        super.done();
    }

    @Override
    @Override
    public Node getStart() {
        if (!this.mob.isInWater()) {
            return super.getStart();
        }
        return this.getStartNode(new BlockPos(Mth.floor(this.mob.getBoundingBox().minX), Mth.floor(this.mob.getBoundingBox().minY + 0.5), Mth.floor(this.mob.getBoundingBox().minZ)));
    }

    @Override
    @Override
    public Target getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y + 0.5, z);
    }

    @Override
    @Override
    public int getNeighbors(Node[] successors, Node node) {
        int k;
        int i = super.getNeighbors(successors, node);
        PathType pathType = this.getCachedPathType(node.x, node.y + 1, node.z);
        PathType pathType2 = this.getCachedPathType(node.x, node.y, node.z);
        if (this.mob.getPathfindingMalus(pathType) >= 0.0f && pathType2 != PathType.STICKY_HONEY) {
            int j = Mth.floor(Math.max(1.0f, this.mob.maxUpStep()));
        } else {
            k = 0;
        }
        double d = this.getFloorLevel(new BlockPos(node.x, node.y, node.z));
        Node node2 = this.findAcceptedNode(node.x, node.y + 1, node.z, Math.max(0, k - 1), d, Direction.UP, pathType2);
        Node node3 = this.findAcceptedNode(node.x, node.y - 1, node.z, k, d, Direction.DOWN, pathType2);
        if (this.isVerticalNeighborValid(node2, node)) {
            successors[i++] = node2;
        }
        if (this.isVerticalNeighborValid(node3, node) && pathType2 != PathType.TRAPDOOR) {
            successors[i++] = node3;
        }
        for (int l = 0; l < i; ++l) {
            Node node4 = successors[l];
            if (node4.type != PathType.WATER || !this.prefersShallowSwimming || node4.y >= this.mob.level().getSeaLevel() - 10) continue;
            node4.costMalus += 1.0f;
        }
        return i;
    }

    private boolean isVerticalNeighborValid(@Nullable Node node, Node successor) {
        return this.isNeighborValid(node, successor) && node.type == PathType.WATER;
    }

    @Override
    @Override
    protected boolean isAmphibious() {
        return true;
    }

    @Override
    @Override
    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        PathType pathType = context.getPathTypeFromState(x, y, z);
        if (pathType == PathType.WATER) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutableBlockPos.set(x, y, z).move(direction);
                PathType pathType2 = context.getPathTypeFromState(mutableBlockPos.getX(), mutableBlockPos.getY(), mutableBlockPos.getZ());
                if (pathType2 != PathType.BLOCKED) continue;
                return PathType.WATER_BORDER;
            }
            return PathType.WATER;
        }
        return super.getPathType(context, x, y, z);
    }
}

