/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class PathTypeCache {
    private static final int SIZE = 4096;
    private static final int MASK = 4095;
    private final long[] positions = new long[4096];
    private final PathType[] pathTypes = new PathType[4096];

    public PathType getOrCompute(BlockGetter world, BlockPos pos) {
        long l = pos.asLong();
        int i = PathTypeCache.index(l);
        PathType pathType = this.get(i, l);
        if (pathType != null) {
            return pathType;
        }
        return this.compute(world, pos, i, l);
    }

    @Nullable
    private PathType get(int index, long pos) {
        if (this.positions[index] == pos) {
            return this.pathTypes[index];
        }
        return null;
    }

    private PathType compute(BlockGetter world, BlockPos pos, int index, long longPos) {
        PathType pathType = WalkNodeEvaluator.getPathTypeFromState(world, pos);
        this.positions[index] = longPos;
        this.pathTypes[index] = pathType;
        return pathType;
    }

    public void invalidate(BlockPos pos) {
        long l = pos.asLong();
        int i = PathTypeCache.index(l);
        if (this.positions[i] == l) {
            this.pathTypes[i] = null;
        }
    }

    private static int index(long pos) {
        return (int)HashCommon.mix((long)pos) & 0xFFF;
    }
}

