/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.PoiAccess;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalForcer {
    public static final int TICKET_RADIUS = 3;
    private static final int SEARCH_RADIUS = 128;
    private static final int CREATE_RADIUS = 16;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final ServerLevel level;

    public PortalForcer(ServerLevel world) {
        this.level = world;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos pos, boolean destIsNether, WorldBorder worldBorder) {
        return this.findPortalAround(pos, worldBorder, destIsNether ? this.level.paperConfig().environment.portalCreateRadius : this.level.paperConfig().environment.portalSearchRadius);
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos blockposition, WorldBorder worldborder, int i) {
        PoiManager villageplace = this.level.getPoiManager();
        ArrayList<PoiRecord> records = new ArrayList<PoiRecord>();
        PoiAccess.findClosestPoiDataRecords(villageplace, type -> type.is(PoiTypes.NETHER_PORTAL), pos -> {
            ChunkAccess lowest = this.level.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.EMPTY);
            if (!(lowest.getStatus().isOrAfter(ChunkStatus.FULL) || lowest.getBelowZeroRetrogen() != null && lowest.getBelowZeroRetrogen().targetStatus().isOrAfter(ChunkStatus.SPAWN))) {
                return false;
            }
            if (!worldborder.isWithinBounds((BlockPos)pos) || this.level.getTypeKey() == LevelStem.NETHER && this.level.paperConfig().environment.netherCeilingVoidDamageHeight.test(v -> pos.getY() >= v)) {
                return false;
            }
            return lowest.getBlockState((BlockPos)pos).hasProperty(BlockStateProperties.HORIZONTAL_AXIS);
        }, blockposition, i, Double.MAX_VALUE, PoiManager.Occupancy.ANY, true, records);
        PoiRecord lowestYRecord = null;
        for (PoiRecord record : records) {
            if (lowestYRecord == null) {
                lowestYRecord = record;
                continue;
            }
            if (lowestYRecord.getPos().getY() <= record.getPos().getY()) continue;
            lowestYRecord = record;
        }
        Optional<Object> optional = Optional.ofNullable(lowestYRecord);
        return optional.map(villageplacerecord -> {
            BlockPos blockposition1 = villageplacerecord.getPos();
            this.level.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(blockposition1), 3, blockposition1);
            BlockState iblockdata = this.level.getBlockState(blockposition1);
            return BlockUtil.getLargestRectangleAround(blockposition1, iblockdata.getValue(BlockStateProperties.HORIZONTAL_AXIS), 21, Direction.Axis.Y, 21, blockposition2 -> this.level.getBlockState((BlockPos)blockposition2) == iblockdata);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pos, Direction.Axis axis) {
        return this.createPortal(pos, axis, null, 16);
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos blockposition, Direction.Axis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        int k1;
        int l;
        int k;
        int j;
        Direction enumdirection = Direction.get(Direction.AxisDirection.POSITIVE, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPos blockposition1 = null;
        double d1 = -1.0;
        BlockPos blockposition2 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        if (this.level.getTypeKey() == LevelStem.NETHER && this.level.paperConfig().environment.netherCeilingVoidDamageHeight.enabled()) {
            i = Math.min(i, this.level.paperConfig().environment.netherCeilingVoidDamageHeight.intValue() - 1);
        }
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (BlockPos.MutableBlockPos blockposition_mutableblockposition1 : BlockPos.spiralAround(blockposition, createRadius, Direction.EAST, Direction.SOUTH)) {
            j = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockposition_mutableblockposition1.getX(), blockposition_mutableblockposition1.getZ()));
            boolean flag = true;
            if (!worldborder.isWithinBounds(blockposition_mutableblockposition1) || !worldborder.isWithinBounds(blockposition_mutableblockposition1.move(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.move(enumdirection.getOpposite(), 1);
            for (k = j; k >= this.level.getMinBuildHeight(); --k) {
                int i1;
                blockposition_mutableblockposition1.setY(k);
                if (!this.canPortalReplaceBlock(blockposition_mutableblockposition1)) continue;
                l = k;
                while (k > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockposition_mutableblockposition1.move(Direction.DOWN))) {
                    --k;
                }
                if (k + 4 > i || (i1 = l - k) > 0 && i1 < 3) continue;
                blockposition_mutableblockposition1.setY(k);
                if (!this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.distSqr(blockposition_mutableblockposition1);
                if (this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.level);
        if (d0 == -1.0) {
            k1 = i - 9;
            int j1 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (k1 < j1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPos(blockposition.getX(), Mth.clamp(blockposition.getY(), j1, k1), blockposition.getZ()).immutable();
            Direction enumdirection1 = enumdirection.getClockWise();
            if (!worldborder.isWithinBounds(blockposition1)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (k = 0; k < 2; ++k) {
                    for (l = -1; l < 3; ++l) {
                        BlockState iblockdata = l < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockposition_mutableblockposition.setWithOffset(blockposition1, k * enumdirection.getStepX() + l1 * enumdirection1.getStepX(), l, k * enumdirection.getStepZ() + l1 * enumdirection1.getStepZ());
                        blockList.setBlock(blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int j1 = -1; j1 < 3; ++j1) {
            for (k1 = -1; k1 < 4; ++k1) {
                if (j1 != -1 && j1 != 2 && k1 != -1 && k1 != 3) continue;
                blockposition_mutableblockposition.setWithOffset(blockposition1, j1 * enumdirection.getStepX(), k1, j1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        BlockState iblockdata1 = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue(NetherPortalBlock.AXIS, enumdirection_enumaxis);
        for (k1 = 0; k1 < 2; ++k1) {
            for (j = 0; j < 3; ++j) {
                blockposition_mutableblockposition.setWithOffset(blockposition1, k1 * enumdirection.getStepX(), j, k1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.level.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.FoundRectangle(blockposition1.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState iblockdata = this.level.getBlockState(pos);
        return iblockdata.canBeReplaced() && iblockdata.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos pos, BlockPos.MutableBlockPos temp, Direction portalDirection, int distanceOrthogonalToPortal) {
        Direction enumdirection1 = portalDirection.getClockWise();
        for (int j = -1; j < 3; ++j) {
            for (int k = -1; k < 4; ++k) {
                temp.setWithOffset(pos, portalDirection.getStepX() * j + enumdirection1.getStepX() * distanceOrthogonalToPortal, k, portalDirection.getStepZ() * j + enumdirection1.getStepZ() * distanceOrthogonalToPortal);
                if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && !this.level.getBlockState(temp).isDestroyable()) {
                    return false;
                }
                if (k < 0 && !this.level.getBlockState(temp).isSolid()) {
                    return false;
                }
                if (k < 0 || this.canPortalReplaceBlock(temp)) continue;
                return false;
            }
        }
        return true;
    }
}

