/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapFrame;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.map.CraftMapRenderer;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.craftbukkit.map.RenderData;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class MapItemSavedData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAP_SIZE = 128;
    private static final int HALF_MAP_SIZE = 64;
    public static final int MAX_SCALE = 4;
    public static final int TRACKED_DECORATION_LIMIT = 256;
    public int centerX;
    public int centerZ;
    public ResourceKey<Level> dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public boolean locked;
    public final List<HoldingPlayer> carriedBy = Lists.newArrayList();
    public final Map<Player, HoldingPlayer> carriedByPlayers = Maps.newHashMap();
    private final Map<String, MapBanner> bannerMarkers = Maps.newHashMap();
    public final Map<String, MapDecoration> decorations = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> frameMarkers = Maps.newHashMap();
    private int trackedDecorationCount;
    private RenderData vanillaRender = new RenderData();
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public MapId id;

    public static SavedData.Factory<MapItemSavedData> factory() {
        return new SavedData.Factory<MapItemSavedData>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, MapItemSavedData::load, DataFixTypes.SAVED_DATA_MAP_DATA);
    }

    private MapItemSavedData(int centerX, int centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, boolean locked, ResourceKey<Level> dimension) {
        this.scale = scale;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.dimension = dimension;
        this.trackingPosition = showDecorations;
        this.unlimitedTracking = unlimitedTracking;
        this.locked = locked;
        this.setDirty();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.colors;
    }

    public static MapItemSavedData createFresh(double centerX, double centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, ResourceKey<Level> dimension) {
        int i = 128 * (1 << scale);
        int j = Mth.floor((centerX + 64.0) / (double)i);
        int k = Mth.floor((centerZ + 64.0) / (double)i);
        int l = j * i + i / 2 - 64;
        int i1 = k * i + i / 2 - 64;
        return new MapItemSavedData(l, i1, scale, showDecorations, unlimitedTracking, false, dimension);
    }

    public static MapItemSavedData createForClient(byte scale, boolean locked, ResourceKey<Level> dimension) {
        return new MapItemSavedData(0, 0, scale, false, false, locked, dimension);
    }

    public static MapItemSavedData load(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        Tag dimension = nbt.get("dimension");
        if (dimension instanceof NumericTag && ((NumericTag)dimension).getAsInt() >= 10) {
            UUID uuid;
            CraftWorld world;
            long least = nbt.getLong("UUIDLeast");
            long most = nbt.getLong("UUIDMost");
            dimension = least != 0L && most != 0L ? ((world = (CraftWorld)Bukkit.getWorld((UUID)(uuid = new UUID(most, least)))) != null ? StringTag.valueOf("minecraft:" + world.getName().toLowerCase(Locale.ENGLISH)) : StringTag.valueOf("bukkit:_invalidworld_")) : StringTag.valueOf("bukkit:_invalidworld_");
        }
        DataResult<ResourceKey<Level>> dataresult = DimensionType.parseLegacy(new Dynamic<Tag>(NbtOps.INSTANCE, dimension));
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbt.getLong("UUIDLeast");
            long most = nbt.getLong("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().dimension();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(nbt.get("dimension")));
        });
        int i = nbt.getInt("xCenter");
        int j = nbt.getInt("zCenter");
        byte b0 = (byte)Mth.clamp(nbt.getByte("scale"), 0, 4);
        boolean flag = !nbt.contains("trackingPosition", 1) || nbt.getBoolean("trackingPosition");
        boolean flag1 = nbt.getBoolean("unlimitedTracking");
        boolean flag2 = nbt.getBoolean("locked");
        MapItemSavedData worldmap = new MapItemSavedData(i, j, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbt.getByteArray("colors");
        if (abyte.length == 16384) {
            worldmap.colors = abyte;
        }
        worldmap.vanillaRender.buffer = abyte;
        RegistryOps<Tag> registryops = registryLookup.createSerializationContext(NbtOps.INSTANCE);
        List list = MapBanner.LIST_CODEC.parse(registryops, (Object)nbt.get("banners")).resultOrPartial(s -> LOGGER.warn("Failed to parse map banner: '{}'", s)).orElse(List.of());
        for (MapBanner mapiconbanner : list) {
            worldmap.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
            worldmap.addDecoration(mapiconbanner.getDecoration(), null, mapiconbanner.getId(), mapiconbanner.pos().getX(), mapiconbanner.pos().getZ(), 180.0, mapiconbanner.name().orElse(null));
        }
        ListTag nbttaglist = nbt.getList("frames", 10);
        for (int k = 0; k < nbttaglist.size(); ++k) {
            MapFrame worldmapframe = MapFrame.load(nbttaglist.getCompound(k));
            if (worldmapframe == null) continue;
            worldmap.frameMarkers.put(worldmapframe.getId(), worldmapframe);
            worldmap.addDecoration(MapDecorationTypes.FRAME, null, "frame-" + worldmapframe.getEntityId(), worldmapframe.getPos().getX(), worldmapframe.getPos().getZ(), worldmapframe.getRotation(), null);
        }
        return worldmap;
    }

    @Override
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        DataResult dataresult = ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.dimension.location());
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("dimension", (Tag)nbtbase));
        if (this.uniqueId == null) {
            for (World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().dimension() != this.dimension) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbt.putLong("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbt.putLong("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbt.putInt("xCenter", this.centerX);
        nbt.putInt("zCenter", this.centerZ);
        nbt.putByte("scale", this.scale);
        nbt.putByteArray("colors", this.colors);
        nbt.putBoolean("trackingPosition", this.trackingPosition);
        nbt.putBoolean("unlimitedTracking", this.unlimitedTracking);
        nbt.putBoolean("locked", this.locked);
        RegistryOps<Tag> registryops = registryLookup.createSerializationContext(NbtOps.INSTANCE);
        nbt.put("banners", (Tag)MapBanner.LIST_CODEC.encodeStart(registryops, List.copyOf(this.bannerMarkers.values())).getOrThrow());
        ListTag nbttaglist = new ListTag();
        for (MapFrame worldmapframe : this.frameMarkers.values()) {
            nbttaglist.add(worldmapframe.save());
        }
        nbt.put("frames", nbttaglist);
        return nbt;
    }

    public MapItemSavedData locked() {
        MapItemSavedData worldmap = new MapItemSavedData(this.centerX, this.centerZ, this.scale, this.trackingPosition, this.unlimitedTracking, true, this.dimension);
        worldmap.bannerMarkers.putAll(this.bannerMarkers);
        worldmap.decorations.putAll(this.decorations);
        worldmap.trackedDecorationCount = this.trackedDecorationCount;
        System.arraycopy(this.colors, 0, worldmap.colors, 0, this.colors.length);
        worldmap.setDirty();
        return worldmap;
    }

    public MapItemSavedData scaled() {
        return MapItemSavedData.createFresh(this.centerX, this.centerZ, (byte)Mth.clamp(this.scale + 1, 0, 4), this.trackingPosition, this.unlimitedTracking, this.dimension);
    }

    private static Predicate<ItemStack> mapMatcher(ItemStack stack) {
        MapId mapid = stack.get(DataComponents.MAP_ID);
        return itemstack1 -> itemstack1 == stack ? true : itemstack1.is(stack.getItem()) && Objects.equals(mapid, itemstack1.get(DataComponents.MAP_ID));
    }

    public void tickCarriedBy(Player player, ItemStack stack) {
        if (!this.carriedByPlayers.containsKey(player)) {
            HoldingPlayer worldmap_worldmaphumantracker = new HoldingPlayer(player);
            this.carriedByPlayers.put(player, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = MapItemSavedData.mapMatcher(stack);
        if (!player.getInventory().contains(predicate)) {
            this.removeDecoration(player.getName().getString());
        }
        for (int i = 0; i < this.carriedBy.size(); ++i) {
            HoldingPlayer worldmap_worldmaphumantracker1 = this.carriedBy.get(i);
            String s = worldmap_worldmaphumantracker1.player.getName().getString();
            if (!worldmap_worldmaphumantracker1.player.isRemoved() && (worldmap_worldmaphumantracker1.player.getInventory().contains(predicate) || stack.isFramed())) {
                if (stack.isFramed() || worldmap_worldmaphumantracker1.player.level().dimension() != this.dimension || !this.trackingPosition) continue;
                this.addDecoration(MapDecorationTypes.PLAYER, worldmap_worldmaphumantracker1.player.level(), s, worldmap_worldmaphumantracker1.player.getX(), worldmap_worldmaphumantracker1.player.getZ(), worldmap_worldmaphumantracker1.player.getYRot(), null);
                continue;
            }
            this.carriedByPlayers.remove(worldmap_worldmaphumantracker1.player);
            this.carriedBy.remove(worldmap_worldmaphumantracker1);
            this.removeDecoration(s);
        }
        if (stack.isFramed() && this.trackingPosition) {
            ItemFrame entityitemframe = stack.getFrame();
            BlockPos blockposition = entityitemframe.getPos();
            MapFrame worldmapframe = this.frameMarkers.get(MapFrame.frameId(blockposition));
            if (worldmapframe != null && entityitemframe.getId() != worldmapframe.getEntityId() && this.frameMarkers.containsKey(worldmapframe.getId())) {
                this.removeDecoration("frame-" + worldmapframe.getEntityId());
            }
            MapFrame worldmapframe1 = new MapFrame(blockposition, entityitemframe.getDirection().get2DDataValue() * 90, entityitemframe.getId());
            if (this.decorations.size() < player.level().paperConfig().maps.itemFrameCursorLimit) {
                this.addDecoration(MapDecorationTypes.FRAME, player.level(), "frame-" + entityitemframe.getId(), blockposition.getX(), blockposition.getZ(), entityitemframe.getDirection().get2DDataValue() * 90, null);
                this.frameMarkers.put(worldmapframe1.getId(), worldmapframe1);
            }
        }
        MapDecorations mapdecorations = stack.getOrDefault(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY);
        if (!this.decorations.keySet().containsAll(mapdecorations.decorations().keySet())) {
            mapdecorations.decorations().forEach((s1, mapdecorations_a) -> {
                if (!this.decorations.containsKey(s1)) {
                    this.addDecoration(mapdecorations_a.type(), player.level(), (String)s1, mapdecorations_a.x(), mapdecorations_a.z(), mapdecorations_a.rotation(), null);
                }
            });
        }
    }

    private void removeDecoration(String id) {
        MapDecoration mapicon = this.decorations.remove(id);
        if (mapicon != null && mapicon.type().value().trackCount()) {
            --this.trackedDecorationCount;
        }
        this.setDecorationsDirty();
    }

    public static void addTargetDecoration(ItemStack stack, BlockPos pos, String id, Holder<MapDecorationType> decorationType) {
        MapDecorations.Entry mapdecorations_a = new MapDecorations.Entry(decorationType, pos.getX(), pos.getZ(), 180.0f);
        stack.update(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY, mapdecorations -> mapdecorations.withDecoration(id, mapdecorations_a));
        if (decorationType.value().hasMapColor()) {
            stack.set(DataComponents.MAP_COLOR, new MapItemColor(decorationType.value().mapColor()));
        }
    }

    private void addDecoration(Holder<MapDecorationType> type, @Nullable LevelAccessor world, String key, double x, double z, double rotation, @Nullable Component text) {
        MapDecoration mapicon1;
        MapDecoration mapicon;
        byte b2;
        int i = 1 << this.scale;
        float f = (float)(x - (double)this.centerX) / (float)i;
        float f1 = (float)(z - (double)this.centerZ) / (float)i;
        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        boolean flag = true;
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.dimension == Level.NETHER && world != null) {
                int j = (int)(world.getLevelData().getDayTime() / 10L);
                b2 = (byte)(j * j * 34187121 + j * 121 >> 15 & 0xF);
            }
        } else {
            if (!type.is(MapDecorationTypes.PLAYER)) {
                this.removeDecoration(key);
                return;
            }
            boolean flag1 = true;
            if (Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f) {
                type = MapDecorationTypes.PLAYER_OFF_MAP;
            } else {
                if (!this.unlimitedTracking) {
                    this.removeDecoration(key);
                    return;
                }
                type = MapDecorationTypes.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapicon = new MapDecoration(type, b0, b1, b2, Optional.ofNullable(text))).equals(mapicon1 = this.decorations.put(key, mapicon))) {
            if (mapicon1 != null && mapicon1.type().value().trackCount()) {
                --this.trackedDecorationCount;
            }
            if (type.value().trackCount()) {
                ++this.trackedDecorationCount;
            }
            this.setDecorationsDirty();
        }
    }

    @Nullable
    public Packet<?> getUpdatePacket(MapId mapId, Player player) {
        HoldingPlayer worldmap_worldmaphumantracker = this.carriedByPlayers.get(player);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.nextUpdatePacket(mapId);
    }

    public void setColorsDirty(int x, int z) {
        this.setDirty();
        for (HoldingPlayer worldmap_worldmaphumantracker : this.carriedBy) {
            worldmap_worldmaphumantracker.markColorsDirty(x, z);
        }
    }

    public void setDecorationsDirty() {
        this.setDirty();
        this.carriedBy.forEach(HoldingPlayer::markDecorationsDirty);
    }

    public HoldingPlayer getHoldingPlayer(Player player) {
        HoldingPlayer worldmap_worldmaphumantracker = this.carriedByPlayers.get(player);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new HoldingPlayer(player);
            this.carriedByPlayers.put(player, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean toggleBanner(LevelAccessor world, BlockPos pos) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getZ() + 0.5;
        int i = 1 << this.scale;
        double d2 = (d0 - (double)this.centerX) / (double)i;
        double d3 = (d1 - (double)this.centerZ) / (double)i;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapBanner mapiconbanner = MapBanner.fromWorld(world, pos);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.bannerMarkers.remove(mapiconbanner.getId(), mapiconbanner)) {
                this.removeDecoration(mapiconbanner.getId());
                return true;
            }
            if (!this.isTrackedCountOverLimit(((Level)world).paperConfig().maps.itemFrameCursorLimit)) {
                this.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
                this.addDecoration(mapiconbanner.getDecoration(), world, mapiconbanner.getId(), d0, d1, 180.0, mapiconbanner.name().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void checkBanners(BlockGetter world, int x, int z) {
        Iterator<MapBanner> iterator = this.bannerMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapiconbanner1;
            MapBanner mapiconbanner = iterator.next();
            if (mapiconbanner.pos().getX() != x || mapiconbanner.pos().getZ() != z || mapiconbanner.equals(mapiconbanner1 = MapBanner.fromWorld(world, mapiconbanner.pos()))) continue;
            iterator.remove();
            this.removeDecoration(mapiconbanner.getId());
        }
    }

    public Collection<MapBanner> getBanners() {
        return this.bannerMarkers.values();
    }

    public void removedFromFrame(BlockPos pos, int id) {
        this.removeDecoration("frame-" + id);
        this.frameMarkers.remove(MapFrame.frameId(pos));
    }

    public boolean updateColor(int x, int z, byte color) {
        byte b1 = this.colors[x + z * 128];
        if (b1 != color) {
            this.setColor(x, z, color);
            return true;
        }
        return false;
    }

    public void setColor(int x, int z, byte color) {
        this.colors[x + z * 128] = color;
        this.setColorsDirty(x, z);
    }

    public boolean isExplorationMap() {
        MapDecoration mapicon;
        Iterator<MapDecoration> iterator = this.decorations.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(mapicon = iterator.next()).type().value().explorationMapElement());
        return true;
    }

    public void addClientSideDecorations(List<MapDecoration> decorations) {
        this.decorations.clear();
        this.trackedDecorationCount = 0;
        for (int i = 0; i < decorations.size(); ++i) {
            MapDecoration mapicon = decorations.get(i);
            this.decorations.put("icon-" + i, mapicon);
            if (!mapicon.type().value().trackCount()) continue;
            ++this.trackedDecorationCount;
        }
    }

    public Iterable<MapDecoration> getDecorations() {
        return this.decorations.values();
    }

    public boolean isTrackedCountOverLimit(int decorationCount) {
        return this.trackedDecorationCount >= decorationCount;
    }

    public class HoldingPlayer {
        public final Player player;
        private boolean dirtyData = true;
        private int minDirtyX;
        private int minDirtyY;
        private int maxDirtyX = 127;
        private int maxDirtyY = 127;
        private boolean dirtyDecorations = true;
        private int tick;
        public int step;

        private void addSeenPlayers(Collection<MapDecoration> icons) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)this.player.getBukkitEntity();
            MapItemSavedData.this.decorations.forEach((name, mapIcon) -> {
                org.bukkit.entity.Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapDecoration)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return MapItemSavedData.this.mapView.getRenderers().size() == 1 && MapItemSavedData.this.mapView.getRenderers().get(0).getClass() == CraftMapRenderer.class;
        }

        HoldingPlayer(Player entityhuman) {
            this.player = entityhuman;
        }

        private MapPatch createPatch(byte[] buffer) {
            int i = this.minDirtyX;
            int j = this.minDirtyY;
            int k = this.maxDirtyX + 1 - this.minDirtyX;
            int l = this.maxDirtyY + 1 - this.minDirtyY;
            byte[] abyte = new byte[k * l];
            for (int i1 = 0; i1 < k; ++i1) {
                for (int j1 = 0; j1 < l; ++j1) {
                    abyte[i1 + j1 * k] = buffer[i + i1 + (j + j1) * 128];
                }
            }
            return new MapPatch(i, j, k, l, abyte);
        }

        @Nullable
        Packet<?> nextUpdatePacket(MapId mapId) {
            ArrayList<MapDecoration> collection;
            MapPatch worldmap_b;
            RenderData render;
            if (!this.dirtyData && this.tick % 5 != 0) {
                ++this.tick;
                return null;
            }
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? MapItemSavedData.this.mapView.render((CraftPlayer)this.player.getBukkitEntity()) : MapItemSavedData.this.vanillaRender;
            if (this.dirtyData) {
                this.dirtyData = false;
                worldmap_b = this.createPatch(render.buffer);
            } else {
                worldmap_b = null;
            }
            if (this.tick++ % 5 == 0) {
                this.dirtyDecorations = false;
                ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapDecoration(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), Optional.ofNullable(PaperAdventure.asVanilla(cursor.caption()))));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_b == null ? null : new ClientboundMapItemDataPacket(mapId, MapItemSavedData.this.scale, MapItemSavedData.this.locked, collection, worldmap_b);
        }

        void markColorsDirty(int startX, int startZ) {
            if (this.dirtyData) {
                this.minDirtyX = Math.min(this.minDirtyX, startX);
                this.minDirtyY = Math.min(this.minDirtyY, startZ);
                this.maxDirtyX = Math.max(this.maxDirtyX, startX);
                this.maxDirtyY = Math.max(this.maxDirtyY, startZ);
            } else {
                this.dirtyData = true;
                this.minDirtyX = startX;
                this.minDirtyY = startZ;
                this.maxDirtyX = startX;
                this.maxDirtyY = startZ;
            }
        }

        private void markDecorationsDirty() {
            this.dirtyDecorations = true;
        }
    }

    public record MapPatch(int startX, int startY, int width, int height, byte[] mapColors) {
        public static final StreamCodec<ByteBuf, Optional<MapPatch>> STREAM_CODEC = StreamCodec.of(MapPatch::write, MapPatch::read);

        private static void write(ByteBuf buf, Optional<MapPatch> updateData) {
            if (updateData.isPresent()) {
                MapPatch worldmap_b = updateData.get();
                buf.writeByte(worldmap_b.width);
                buf.writeByte(worldmap_b.height);
                buf.writeByte(worldmap_b.startX);
                buf.writeByte(worldmap_b.startY);
                FriendlyByteBuf.writeByteArray(buf, worldmap_b.mapColors);
            } else {
                buf.writeByte(0);
            }
        }

        private static Optional<MapPatch> read(ByteBuf buf) {
            short short0 = buf.readUnsignedByte();
            if (short0 > 0) {
                short short1 = buf.readUnsignedByte();
                short short2 = buf.readUnsignedByte();
                short short3 = buf.readUnsignedByte();
                byte[] abyte = FriendlyByteBuf.readByteArray(buf);
                return Optional.of(new MapPatch(short2, short3, short0, short1, abyte));
            }
            return Optional.empty();
        }

        public void applyToMap(MapItemSavedData mapState) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    mapState.setColor(this.startX + i, this.startY + j, this.mapColors[i + j * this.width]);
                }
            }
        }
    }
}

