/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage
implements Closeable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, SavedData> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final File dataFolder;
    protected final ExecutorService ioExecutor;

    public DimensionDataStorage(File directory, DataFixer dataFixer, HolderLookup.Provider registryLookup) {
        this.fixerUpper = dataFixer;
        this.dataFolder = directory;
        this.registries = registryLookup;
        this.ioExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("DimensionDataIO - " + this.dataFolder.getParent() + " - %d").setDaemon(true).build());
    }

    private File getDataFile(String id) {
        return new File(this.dataFolder, id + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> type, String id) {
        T savedData = this.get(type, id);
        if (savedData != null) {
            return savedData;
        }
        SavedData savedData2 = (SavedData)type.constructor().get();
        this.set(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> type, String id) {
        SavedData savedData = this.cache.get(id);
        if (savedData == null && !this.cache.containsKey(id)) {
            savedData = this.readSavedData(type.deserializer(), type.type(), id);
            this.cache.put(id, savedData);
        }
        return (T)savedData;
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> readFunction, DataFixTypes dataFixTypes, String id) {
        try {
            File file = this.getDataFile(id);
            if (file.exists()) {
                CompoundTag compoundTag = this.readTagFromDisk(id, dataFixTypes, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)readFunction.apply(compoundTag.getCompound("data"), this.registries));
            }
        }
        catch (Exception var6) {
            LOGGER.error("Error loading saved data: {}", (Object)id, (Object)var6);
        }
        return null;
    }

    public void set(String id, SavedData state) {
        this.cache.put(id, state);
    }

    public CompoundTag readTagFromDisk(String id, DataFixTypes dataFixTypes, int currentSaveVersion) throws IOException {
        CompoundTag var9;
        File file = this.getDataFile(id);
        try (FileInputStream inputStream = new FileInputStream(file);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            CompoundTag compoundTag;
            if (this.isGzip(pushbackInputStream)) {
                compoundTag = NbtIo.readCompressed(pushbackInputStream, NbtAccounter.unlimitedHeap());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compoundTag = NbtIo.read(dataInputStream);
                }
            }
            int i = NbtUtils.getDataVersion(compoundTag, 1343);
            var9 = dataFixTypes.update(this.fixerUpper, compoundTag, i, currentSaveVersion);
        }
        return var9;
    }

    private boolean isGzip(PushbackInputStream stream) throws IOException {
        int j;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i = stream.read(bs, 0, 2);
        if (i == 2 && (j = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i != 0) {
            stream.unread(bs, 0, i);
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        this.save(false);
        this.ioExecutor.shutdown();
    }

    public void save(boolean async) {
        this.cache.forEach((id, state) -> {
            if (state != null) {
                CompletableFuture<Void> save = state.save(this.getDataFile((String)id), this.registries, this.ioExecutor);
                if (!async) {
                    save.join();
                }
            }
        });
    }
}

