/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetPotionFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetPotionFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetPotionFunction.commonFields(instance).and((App)BuiltInRegistries.POTION.holderByNameCodec().fieldOf("id").forGetter(function -> function.potion)).apply((Applicative)instance, SetPotionFunction::new));
    private final Holder<Potion> potion;

    private SetPotionFunction(List<LootItemCondition> conditions, Holder<Potion> potion) {
        super(conditions);
        this.potion = potion;
    }

    @Override
    public LootItemFunctionType<SetPotionFunction> getType() {
        return LootItemFunctions.SET_POTION;
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        stack.update(DataComponents.POTION_CONTENTS, PotionContents.EMPTY, this.potion, PotionContents::withPotion);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setPotion(Holder<Potion> potion) {
        return SetPotionFunction.simpleBuilder(conditions -> new SetPotionFunction((List<LootItemCondition>)conditions, potion));
    }
}

