/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import org.leavesmc.leaves.LeavesConfig;

public class CubePointRange
extends AbstractDoubleList {
    private final int size;
    private final int parts;
    private final double scale;

    CubePointRange(int sectionCount) {
        if (sectionCount <= 0) {
            throw new IllegalArgumentException("Need at least 1 part");
        }
        this.parts = sectionCount;
        this.size = sectionCount + 1;
        this.scale = 1.0 / (double)sectionCount;
    }

    public double getDouble(int i) {
        if (!LeavesConfig.optimizedCubePointRange) {
            return (double)i / (double)this.parts;
        }
        return (double)i * this.scale;
    }

    public int size() {
        return !LeavesConfig.optimizedCubePointRange ? this.parts + 1 : this.size;
    }
}

