/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.leavesmc.leaves.LeavesConfig;

public final class CubeVoxelShape
extends VoxelShape {
    private DoubleList[] list = null;

    protected CubeVoxelShape(DiscreteVoxelShape voxels) {
        super(voxels);
        this.initCache();
    }

    @Override
    protected DoubleList getCoords(Direction.Axis axis) {
        if (!LeavesConfig.cacheCubeVoxelShapeShapeArray) {
            return new CubePointRange(this.shape.getSize(axis));
        }
        if (this.list == null) {
            this.list = new DoubleList[Direction.Axis.VALUES.length];
            for (Direction.Axis existingAxis : Direction.Axis.VALUES) {
                this.list[existingAxis.ordinal()] = new CubePointRange(this.shape.getSize(axis));
            }
        }
        return this.list[axis.ordinal()];
    }

    @Override
    protected int findIndex(Direction.Axis axis, double coord) {
        int i = this.shape.getSize(axis);
        return Mth.floor(Mth.clamp(coord * (double)i, -1.0, (double)i));
    }
}

