/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CraftBlockEntityState<T extends BlockEntity>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;
    public boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, ((BlockEntity)tileEntity).getBlockPos(), ((BlockEntity)tileEntity).getBlockState());
        this.tileEntity = tileEntity;
        try {
            this.snapshotDisabled = DISABLE_SNAPSHOT;
            this.snapshot = DISABLE_SNAPSHOT ? this.tileEntity : this.createSnapshot(tileEntity);
            if (this.snapshot != null) {
                this.load(this.snapshot);
            }
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            throw new RuntimeException("Failed to read BlockState at: world: " + this.getWorld().getName() + " location: (" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")", thr);
        }
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    private RegistryAccess getRegistryAccess() {
        LevelAccessor worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.registryAccess() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        CompoundTag nbtTagCompound = ((BlockEntity)tileEntity).saveWithFullMetadata(this.getRegistryAccess());
        BlockEntity snapshot = BlockEntity.loadStatic(this.getPosition(), this.getHandle(), nbtTagCompound, this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<DataComponentType<?>> applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        Set<DataComponentType<?>> result = ((BlockEntity)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public DataComponentMap collectComponents() {
        return ((BlockEntity)this.snapshot).collectComponents();
    }

    public void loadData(CompoundTag nbtTagCompound) {
        ((BlockEntity)this.snapshot).loadWithComponents(nbtTagCompound, this.getRegistryAccess());
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        CompoundTag nbtTagCompound = ((BlockEntity)from).saveWithFullMetadata(this.getRegistryAccess());
        ((BlockEntity)to).loadWithComponents(nbtTagCompound, this.getRegistryAccess());
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected BlockEntity getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().getBlockEntity(this.getPosition());
    }

    public CompoundTag getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((BlockEntity)this.snapshot).saveWithFullMetadata(this.getRegistryAccess());
    }

    public CompoundTag getSnapshotNBTWithoutComponents() {
        CompoundTag nbt = this.getSnapshotNBT();
        ((BlockEntity)this.snapshot).removeComponentsFromTag(nbt);
        return nbt;
    }

    public CompoundTag getSnapshotCustomNbtOnly() {
        this.applyTo(this.snapshot);
        CompoundTag nbt = ((BlockEntity)this.snapshot).saveCustomOnly(this.getRegistryAccess());
        ((BlockEntity)this.snapshot).removeComponentsFromTag(nbt);
        if (!nbt.isEmpty()) {
            ((BlockEntity)this.snapshot).saveId(nbt);
        }
        return nbt;
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(BlockEntity tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        BlockEntity tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.setChanged();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((BlockEntity)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket(@NotNull Location location) {
        BlockEntity vanillaTileEntitiy = BlockEntity.loadStatic(CraftLocation.toBlockPosition(location), this.getHandle(), this.getSnapshotNBT(), this.getRegistryAccess());
        return ClientboundBlockEntityDataPacket.create(vanillaTileEntitiy);
    }

    @Override
    public abstract CraftBlockEntityState<T> copy();

    @Override
    public abstract CraftBlockEntityState<T> copy(Location var1);

    public boolean isSnapshot() {
        return !this.snapshotDisabled;
    }
}

