/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class CraftCreatureSpawner
extends CraftBlockEntityState<SpawnerBlockEntity>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, SpawnerBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        Optional<net.minecraft.world.entity.EntityType<?>> type = net.minecraft.world.entity.EntityType.by(spawnData.getEntityToSpawn());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials = SimpleWeightedRandomList.empty();
            ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData = new SpawnData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().getRandom() : RandomSource.create();
        ((SpawnerBlockEntity)this.getSnapshot()).setEntityId(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.getEntityToSpawn());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials = SimpleWeightedRandomList.empty();
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData = new SpawnData(compoundTag, Optional.empty(), Optional.empty());
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        SimpleWeightedRandomList.Builder<SpawnData> builder = SimpleWeightedRandomList.builder();
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials.unwrap().forEach(entry -> builder.add((SpawnData)entry.data(), entry.getWeight().asInt()));
        builder.add(new SpawnData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnRule)), Optional.empty()), weight);
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials = builder.build();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        SimpleWeightedRandomList.Builder<SpawnData> builder = SimpleWeightedRandomList.builder();
        for (SpawnerEntry spawnerEntry : entries) {
            CompoundTag compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.add(new SpawnData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials = builder.build();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (WeightedEntry.Wrapper entry : ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnPotentials.unwrap()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((SpawnData)entry.data()).getEntityToSpawn());
            if (snapshot == null) continue;
            SpawnRule rule = ((SpawnData)entry.data()).customSpawnRules().map(this::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.getWeight().asInt(), rule, CraftCreatureSpawner.getEquipment(((SpawnData)entry.data()).equipment())));
        }
        return entries;
    }

    private SpawnData.CustomSpawnRules toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new SpawnData.CustomSpawnRules(new InclusiveRange<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new InclusiveRange<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    private SpawnRule fromMinecraftRule(SpawnData.CustomSpawnRules rule) {
        InclusiveRange<Integer> blockLight = rule.blockLightLimit();
        InclusiveRange<Integer> skyLight = rule.skyLightLimit();
        return new SpawnRule(blockLight.maxInclusive().intValue(), blockLight.maxInclusive().intValue(), skyLight.minInclusive().intValue(), skyLight.maxInclusive().intValue());
    }

    public String getCreatureTypeName() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        Optional<net.minecraft.world.entity.EntityType<?>> type = net.minecraft.world.entity.EntityType.by(spawnData.getEntityToSpawn());
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnDelay;
    }

    public void setDelay(int delay) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnDelay = delay;
    }

    public int getMinSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().minSpawnDelay;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().minSpawnDelay = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxSpawnDelay;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxSpawnDelay = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().maxNearbyEntities = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnCount;
    }

    public void setSpawnCount(int count) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnCount = count;
    }

    public int getRequiredPlayerRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().spawnRange = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    private static Optional<EquipmentTable> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new EquipmentTable(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((org.bukkit.inventory.EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    private static SpawnerEntry.Equipment getEquipment(Optional<EquipmentTable> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.lootTable()), new HashMap<org.bukkit.inventory.EquipmentSlot, Float>(nms.slotDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((EquipmentSlot)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }

    public boolean isActivated() {
        this.requirePlaced();
        return ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().isNearPlayer(this.world.getHandle(), this.getPosition());
    }

    public void resetTimer() {
        this.requirePlaced();
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().delay(this.world.getHandle(), this.getPosition());
    }

    public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        CompoundTag entity = new CompoundTag();
        entity.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(net.minecraft.world.entity.EntityType.ITEM).toString());
        entity.put("Item", item.save(this.world.getHandle().registryAccess()));
        ((SpawnerBlockEntity)this.getSnapshot()).getSpawner().setNextSpawnData(this.isPlaced() ? this.world.getHandle() : null, this.getPosition(), new SpawnData(entity, Optional.empty(), Optional.ofNullable(((SpawnerBlockEntity)this.getSnapshot()).getSpawner().nextSpawnData).flatMap(SpawnData::equipment)));
    }
}

