/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EnderChest;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;

public class CraftEnderChest
extends CraftBlockEntityState<EnderChestBlockEntity>
implements EnderChest {
    public CraftEnderChest(World world, EnderChestBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftEnderChest(CraftEnderChest state, Location location) {
        super(state, location);
    }

    public void open() {
        this.requirePlaced();
        if (!((EnderChestBlockEntity)this.getTileEntity()).openersCounter.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((EnderChestBlockEntity)this.getTileEntity()).getBlockState();
            int openCount = ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.getOpenerCount();
            ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.onAPIOpen((Level)this.getWorldHandle(), this.getPosition(), block);
            ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.openerAPICountChanged((Level)this.getWorldHandle(), this.getPosition(), block, openCount, openCount + 1);
        }
        ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((EnderChestBlockEntity)this.getTileEntity()).openersCounter.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((EnderChestBlockEntity)this.getTileEntity()).getBlockState();
            int openCount = ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.getOpenerCount();
            ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.onAPIClose((Level)this.getWorldHandle(), this.getPosition(), block);
            ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.openerAPICountChanged((Level)this.getWorldHandle(), this.getPosition(), block, openCount, 0);
        }
        ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.opened = false;
    }

    @Override
    public CraftEnderChest copy() {
        return new CraftEnderChest(this, null);
    }

    @Override
    public CraftEnderChest copy(Location location) {
        return new CraftEnderChest(this, location);
    }

    public boolean isOpen() {
        return ((EnderChestBlockEntity)this.getTileEntity()).openersCounter.opened;
    }

    public boolean isBlocked() {
        BlockPos abovePos = this.getPosition().above();
        return this.isPlaced() && this.getWorldHandle().getBlockState(abovePos).isRedstoneConductor(this.getWorldHandle(), abovePos);
    }
}

