/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

public final class CraftRedstoneWire
extends CraftBlockData
implements RedstoneWire,
AnaloguePowerable {
    private static final EnumProperty<?> NORTH = CraftRedstoneWire.getEnum(RedStoneWireBlock.class, "north");
    private static final EnumProperty<?> EAST = CraftRedstoneWire.getEnum(RedStoneWireBlock.class, "east");
    private static final EnumProperty<?> SOUTH = CraftRedstoneWire.getEnum(RedStoneWireBlock.class, "south");
    private static final EnumProperty<?> WEST = CraftRedstoneWire.getEnum(RedStoneWireBlock.class, "west");
    private static final IntegerProperty POWER = CraftRedstoneWire.getInteger(RedStoneWireBlock.class, "power");

    public CraftRedstoneWire() {
    }

    public CraftRedstoneWire(BlockState state) {
        super(state);
    }

    public RedstoneWire.Connection getFace(BlockFace face) {
        switch (face) {
            case NORTH: {
                return this.get(NORTH, RedstoneWire.Connection.class);
            }
            case EAST: {
                return this.get(EAST, RedstoneWire.Connection.class);
            }
            case SOUTH: {
                return this.get(SOUTH, RedstoneWire.Connection.class);
            }
            case WEST: {
                return this.get(WEST, RedstoneWire.Connection.class);
            }
        }
        throw new IllegalArgumentException("Cannot have face " + String.valueOf(face));
    }

    public void setFace(BlockFace face, RedstoneWire.Connection connection) {
        switch (face) {
            case NORTH: {
                this.set(NORTH, connection);
                break;
            }
            case EAST: {
                this.set(EAST, connection);
                break;
            }
            case SOUTH: {
                this.set(SOUTH, connection);
                break;
            }
            case WEST: {
                this.set(WEST, connection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot have face " + String.valueOf(face));
            }
        }
    }

    public Set<BlockFace> getAllowedFaces() {
        return ImmutableSet.of((Object)BlockFace.NORTH, (Object)BlockFace.EAST, (Object)BlockFace.SOUTH, (Object)BlockFace.WEST);
    }

    public int getPower() {
        return this.get(POWER);
    }

    public void setPower(int power) {
        this.set(POWER, power);
    }

    public int getMaximumPower() {
        return CraftRedstoneWire.getMax(POWER);
    }
}

