/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.entity.AbstractProjectile;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;

public class CraftAbstractArrow
extends AbstractProjectile
implements org.bukkit.entity.AbstractArrow {
    public CraftAbstractArrow(CraftServer server, AbstractArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
        Preconditions.checkArgument((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback value (%s) cannot be negative", (int)knockbackStrength);
        this.getHandle().setKnockback(knockbackStrength);
    }

    public int getKnockbackStrength() {
        return this.getHandle().knockback;
    }

    public double getDamage() {
        return this.getHandle().getBaseDamage();
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().setBaseDamage(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().getPierceLevel();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().setPierceLevel((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().isCritArrow();
    }

    public void setCritical(boolean critical) {
        this.getHandle().setCritArrow(critical);
    }

    public boolean isInBlock() {
        return this.getHandle().inGround;
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPos pos = this.getHandle().blockPosition();
        return this.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().pickup.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().pickup = AbstractArrow.Pickup.byOrdinal(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().life = value;
    }

    public boolean isShotFromCrossbow() {
        return this.getHandle().shotFromCrossbow();
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.getHandle().setShotFromCrossbow(shotFromCrossbow);
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().pickupItemStack);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().pickupItemStack = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public AbstractArrow getHandle() {
        return (AbstractArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }

    public CraftItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().getPickupItem());
    }

    public void setLifetimeTicks(int ticks) {
        this.getHandle().life = ticks;
    }

    public int getLifetimeTicks() {
        return this.getHandle().life;
    }

    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().soundEvent);
    }

    public void setHitSound(Sound sound) {
        this.getHandle().setSoundEvent(CraftSound.bukkitToMinecraft(sound));
    }
}

