/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftProjectile;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();

    public CraftFirework(CraftServer server, FireworkRocketEntity entity) {
        super(server, entity);
    }

    @Override
    public FireworkRocketEntity getHandle() {
        return (FireworkRocketEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)CraftItemStack.getItemMeta(this.getHandle().getEntityData().get(FireworkRocketEntity.DATA_ID_FIREWORKS_ITEM), Material.FIREWORK_ROCKET);
    }

    public void setFireworkMeta(FireworkMeta meta) {
        this.applyFireworkEffect(meta);
        this.getHandle().lifetime = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().getEntityData().markDirty(FireworkRocketEntity.DATA_ID_FIREWORKS_ITEM);
    }

    public boolean setAttachedTo(org.bukkit.entity.LivingEntity entity) {
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().attachedToEntity = entity != null ? ((CraftLivingEntity)entity).getHandle() : null;
        this.getHandle().getEntityData().set(FireworkRocketEntity.DATA_ATTACHED_TO_TARGET, entity != null ? OptionalInt.of(entity.getEntityId()) : OptionalInt.empty());
        return true;
    }

    public org.bukkit.entity.LivingEntity getAttachedTo() {
        LivingEntity entity = this.getHandle().attachedToEntity;
        return entity != null ? (org.bukkit.entity.LivingEntity)entity.getBukkitEntity() : null;
    }

    public boolean setLife(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be greater than or equal to 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().life = ticks;
        return true;
    }

    public int getLife() {
        return this.getHandle().life;
    }

    public boolean setMaxLife(int ticks) {
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be greater than 0");
        if (this.isDetonated()) {
            return false;
        }
        this.getHandle().lifetime = ticks;
        return true;
    }

    public int getMaxLife() {
        return this.getHandle().lifetime;
    }

    public void detonate() {
        this.setLife(this.getMaxLife() + 1);
    }

    public boolean isDetonated() {
        return this.getHandle().life > this.getHandle().lifetime;
    }

    public boolean isShotAtAngle() {
        return this.getHandle().isShotAtAngle();
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().getEntityData().set(FireworkRocketEntity.DATA_SHOT_AT_ANGLE, shotAtAngle);
    }

    public UUID getSpawningEntity() {
        return this.getHandle().spawningEntity;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getItem());
    }

    public void setItem(ItemStack itemStack) {
        FireworkMeta meta = this.getFireworkMeta();
        net.minecraft.world.item.ItemStack nmsItem = itemStack == null ? FireworkRocketEntity.getDefaultItem() : CraftItemStack.asNMSCopy(itemStack);
        this.getHandle().getEntityData().set(FireworkRocketEntity.DATA_ID_FIREWORKS_ITEM, nmsItem);
        this.applyFireworkEffect(meta);
    }

    public int getTicksFlown() {
        return this.getHandle().life;
    }

    public void setTicksFlown(int ticks) {
        this.getHandle().life = ticks;
    }

    public int getTicksToDetonate() {
        return this.getHandle().lifetime;
    }

    public void setTicksToDetonate(int ticks) {
        this.getHandle().lifetime = ticks;
    }

    void applyFireworkEffect(FireworkMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().getItem();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().getEntityData().set(FireworkRocketEntity.DATA_ID_FIREWORKS_ITEM, item);
    }
}

