/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.FishingHook;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;

public class CraftFishHook
extends CraftProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, FishingHook entity) {
        super(server, entity);
    }

    @Override
    public FishingHook getHandle() {
        return (FishingHook)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    public int getMinWaitTime() {
        return this.getHandle().minWaitTime;
    }

    public void setMinWaitTime(int minWaitTime) {
        Preconditions.checkArgument((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (String)"The minimum wait time should be between %s and %s (the maximum wait time)", (int)0, (int)this.getMaxWaitTime());
        FishingHook hook = this.getHandle();
        hook.minWaitTime = minWaitTime;
    }

    public int getMaxWaitTime() {
        return this.getHandle().maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        Preconditions.checkArgument((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (String)"The maximum wait time should be between %s and %s (the minimum wait time)", (int)0, (int)this.getMinWaitTime());
        FishingHook hook = this.getHandle();
        hook.maxWaitTime = maxWaitTime;
    }

    public void setWaitTime(int min, int max) {
        Preconditions.checkArgument((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (Object)"The minimum/maximum wait time should be higher than or equal to 0 and the minimum wait time");
        this.getHandle().minWaitTime = min;
        this.getHandle().maxWaitTime = max;
    }

    public int getMinLureTime() {
        return this.getHandle().minLureTime;
    }

    public void setMinLureTime(int minLureTime) {
        Preconditions.checkArgument((minLureTime >= 0 && minLureTime <= this.getMaxLureTime() ? 1 : 0) != 0, (String)"The minimum lure time (%s) should be between 0 and %s (the maximum wait time)", (int)minLureTime, (int)this.getMaxLureTime());
        this.getHandle().minLureTime = minLureTime;
    }

    public int getMaxLureTime() {
        return this.getHandle().maxLureTime;
    }

    public void setMaxLureTime(int maxLureTime) {
        Preconditions.checkArgument((maxLureTime >= 0 && maxLureTime >= this.getMinLureTime() ? 1 : 0) != 0, (String)"The maximum lure time (%s) should be higher than or equal to 0 and %s (the minimum wait time)", (int)maxLureTime, (int)this.getMinLureTime());
        this.getHandle().maxLureTime = maxLureTime;
    }

    public void setLureTime(int min, int max) {
        Preconditions.checkArgument((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (Object)"The minimum/maximum lure time should be higher than or equal to 0 and the minimum wait time.");
        this.getHandle().minLureTime = min;
        this.getHandle().maxLureTime = max;
    }

    public float getMinLureAngle() {
        return this.getHandle().minLureAngle;
    }

    public void setMinLureAngle(float minLureAngle) {
        Preconditions.checkArgument((minLureAngle <= this.getMaxLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle (%s) should be less than %s (the maximum lure angle)", (Object)Float.valueOf(minLureAngle), (Object)Float.valueOf(this.getMaxLureAngle()));
        this.getHandle().minLureAngle = minLureAngle;
    }

    public float getMaxLureAngle() {
        return this.getHandle().maxLureAngle;
    }

    public void setMaxLureAngle(float maxLureAngle) {
        Preconditions.checkArgument((maxLureAngle >= this.getMinLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle (%s) should be less than %s (the maximum lure angle)", (Object)Float.valueOf(maxLureAngle), (Object)Float.valueOf(this.getMinLureAngle()));
        this.getHandle().maxLureAngle = maxLureAngle;
    }

    public void setLureAngle(float min, float max) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (String)"The minimum lure (%s) angle should be less than the maximum lure angle (%s)", (Object)Float.valueOf(min), (Object)Float.valueOf(max));
        this.getHandle().minLureAngle = min;
        this.getHandle().maxLureAngle = max;
    }

    public boolean isSkyInfluenced() {
        return this.getHandle().skyInfluenced;
    }

    public void setSkyInfluenced(boolean skyInfluenced) {
        this.getHandle().skyInfluenced = skyInfluenced;
    }

    public boolean isRainInfluenced() {
        return this.getHandle().rainInfluenced;
    }

    public void setRainInfluenced(boolean rainInfluenced) {
        this.getHandle().rainInfluenced = rainInfluenced;
    }

    public boolean getApplyLure() {
        return this.getHandle().applyLure;
    }

    public void setApplyLure(boolean applyLure) {
        this.getHandle().applyLure = applyLure;
    }

    public double getBiteChance() {
        FishingHook hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.level().isRainingAt(BlockPos.containing(hook.position()).offset(0, 1, 0))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    public void setBiteChance(double chance) {
        Preconditions.checkArgument((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"The bite chance must be between 0 and 1");
        this.biteChance = chance;
    }

    public boolean isInOpenWater() {
        return this.getHandle().outOfWaterTime < 10 && this.getHandle().calculateOpenWater(this.getHandle().blockPosition());
    }

    public Entity getHookedEntity() {
        net.minecraft.world.entity.Entity hooked = this.getHandle().hookedIn;
        return hooked != null ? hooked.getBukkitEntity() : null;
    }

    public void setHookedEntity(Entity entity) {
        FishingHook hook = this.getHandle();
        hook.hookedIn = entity != null ? ((CraftEntity)entity).getHandle() : null;
        hook.getEntityData().set(FishingHook.DATA_HOOKED_ENTITY, hook.hookedIn != null ? hook.hookedIn.getId() + 1 : 0);
    }

    public boolean pullHookedEntity() {
        FishingHook hook = this.getHandle();
        if (hook.hookedIn == null) {
            return false;
        }
        hook.pullEntity(hook.hookedIn);
        return true;
    }

    public FishHook.HookState getState() {
        return FishHook.HookState.values()[this.getHandle().currentState.ordinal()];
    }

    public int getWaitTime() {
        return this.getHandle().timeUntilLured;
    }

    public void setWaitTime(int ticks) {
        this.getHandle().timeUntilLured = ticks;
    }

    public int getTimeUntilBite() {
        return this.getHandle().timeUntilHooked;
    }

    public void setTimeUntilBite(int ticks) {
        boolean alreadyInLuringPhase;
        Preconditions.checkArgument((ticks >= 1 ? 1 : 0) != 0, (String)"Cannot set time until bite to less than 1 (%s<1)", (int)ticks);
        FishingHook hook = this.getHandle();
        boolean bl = alreadyInLuringPhase = hook.timeUntilHooked > 0 && hook.timeUntilLured <= 0;
        if (!alreadyInLuringPhase) {
            hook.fishAngle = Mth.nextFloat(hook.random, hook.minLureAngle, hook.maxLureAngle);
            hook.timeUntilLured = 0;
        }
        hook.timeUntilHooked = ticks;
    }

    public void resetFishingState() {
        FishingHook hook = this.getHandle();
        hook.resetTimeUntilLured();
        hook.timeUntilHooked = 0;
    }
}

