/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.entity.Villager;

public class CraftZombie
extends CraftMonster
implements org.bukkit.entity.Zombie {
    public CraftZombie(CraftServer server, Zombie entity) {
        super(server, entity);
    }

    @Override
    public Zombie getHandle() {
        return (Zombie)this.entity;
    }

    @Override
    public String toString() {
        return "CraftZombie";
    }

    public boolean isBaby() {
        return this.getHandle().isBaby();
    }

    public void setBaby(boolean flag) {
        this.getHandle().setBaby(flag);
    }

    public boolean isVillager() {
        return this.getHandle() instanceof ZombieVillager;
    }

    public void setVillager(boolean flag) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setVillagerProfession(Villager.Profession profession) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Villager.Profession getVillagerProfession() {
        return null;
    }

    public boolean isConverting() {
        return this.getHandle().isUnderWaterConverting();
    }

    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().conversionTime;
    }

    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().conversionTime = -1;
            this.getHandle().getEntityData().set(Zombie.DATA_DROWNED_CONVERSION_ID, false);
        } else {
            this.getHandle().startUnderWaterConversion(time);
        }
    }

    public int getAge() {
        return this.getHandle().isBaby() ? -1 : 0;
    }

    public void setAge(int i) {
        this.getHandle().setBaby(i < 0);
    }

    public void setAgeLock(boolean b) {
    }

    public boolean isDrowning() {
        return this.getHandle().isUnderWaterConverting();
    }

    public void startDrowning(int drownedConversionTime) {
        this.getHandle().startUnderWaterConversion(drownedConversionTime);
    }

    public void stopDrowning() {
        this.getHandle().stopDrowning();
    }

    public boolean shouldBurnInDay() {
        return this.getHandle().isSunSensitive();
    }

    public boolean isArmsRaised() {
        return this.getHandle().isAggressive();
    }

    public void setArmsRaised(boolean raised) {
        this.getHandle().setAggressive(raised);
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.getHandle().setShouldBurnInDay(shouldBurnInDay);
    }

    public boolean supportsBreakingDoors() {
        return this.getHandle().supportsBreakDoorGoal();
    }

    public boolean getAgeLock() {
        return false;
    }

    public void setBaby() {
        this.getHandle().setBaby(true);
    }

    public void setAdult() {
        this.getHandle().setBaby(false);
    }

    public boolean isAdult() {
        return !this.getHandle().isBaby();
    }

    public boolean canBreed() {
        return false;
    }

    public void setBreed(boolean b) {
    }

    public boolean canBreakDoors() {
        return this.getHandle().canBreakDoors();
    }

    public void setCanBreakDoors(boolean flag) {
        this.getHandle().setCanBreakDoors(flag);
    }
}

