/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import net.kyori.adventure.text.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends AbstractContainerMenu {
    private final InventoryView view;
    private InventoryType cachedType;
    private AbstractContainerMenu delegate;

    public CraftContainer(InventoryView view, Player player, int id) {
        super(CraftContainer.getNotchInventoryType(view.getTopInventory()), id);
        this.view = view;
        Container top = ((CraftInventory)view.getTopInventory()).getInventory();
        net.minecraft.world.entity.player.Inventory bottom = (net.minecraft.world.entity.player.Inventory)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final Player player, int id) {
        this(new InventoryView(){
            private final String originalTitle;
            private String title;
            {
                this.title = this.originalTitle = inventory instanceof CraftInventoryCustom ? ((CraftInventoryCustom)inventory).getTitle() : inventory.getType().getDefaultTitle();
            }

            public Inventory getTopInventory() {
                return inventory;
            }

            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            public HumanEntity getPlayer() {
                return player.getBukkitEntity();
            }

            public InventoryType getType() {
                return inventory.getType();
            }

            public Component title() {
                Component component;
                if (inventory instanceof CraftInventoryCustom) {
                    CraftInventoryCustom custom = (CraftInventoryCustom)inventory;
                    component = custom.title();
                } else {
                    component = inventory.getType().defaultTitle();
                }
                return component;
            }

            public String getTitle() {
                return this.title;
            }

            public String getOriginalTitle() {
                return this.originalTitle;
            }

            public void setTitle(String title) {
                CraftInventoryView.sendInventoryTitleChange(this, title);
                this.title = title;
            }
        }, player, id);
    }

    @Override
    public InventoryView getBukkitView() {
        return this.view;
    }

    public static MenuType getNotchInventoryType(Inventory inventory) {
        switch (inventory.getType()) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                switch (inventory.getSize()) {
                    case 9: {
                        return MenuType.GENERIC_9x1;
                    }
                    case 18: {
                        return MenuType.GENERIC_9x2;
                    }
                    case 27: {
                        return MenuType.GENERIC_9x3;
                    }
                    case 36: 
                    case 41: {
                        return MenuType.GENERIC_9x4;
                    }
                    case 45: {
                        return MenuType.GENERIC_9x5;
                    }
                    case 54: {
                        return MenuType.GENERIC_9x6;
                    }
                }
                throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
            }
            case WORKBENCH: {
                return MenuType.CRAFTING;
            }
            case FURNACE: {
                return MenuType.FURNACE;
            }
            case DISPENSER: {
                return MenuType.GENERIC_3x3;
            }
            case ENCHANTING: {
                return MenuType.ENCHANTMENT;
            }
            case BREWING: {
                return MenuType.BREWING_STAND;
            }
            case BEACON: {
                return MenuType.BEACON;
            }
            case ANVIL: {
                return MenuType.ANVIL;
            }
            case HOPPER: {
                return MenuType.HOPPER;
            }
            case DROPPER: {
                return MenuType.GENERIC_3x3;
            }
            case SHULKER_BOX: {
                return MenuType.SHULKER_BOX;
            }
            case BLAST_FURNACE: {
                return MenuType.BLAST_FURNACE;
            }
            case LECTERN: {
                return MenuType.LECTERN;
            }
            case SMOKER: {
                return MenuType.SMOKER;
            }
            case LOOM: {
                return MenuType.LOOM;
            }
            case CARTOGRAPHY: {
                return MenuType.CARTOGRAPHY_TABLE;
            }
            case GRINDSTONE: {
                return MenuType.GRINDSTONE;
            }
            case STONECUTTER: {
                return MenuType.STONECUTTER;
            }
            case SMITHING: 
            case SMITHING_NEW: {
                return MenuType.SMITHING;
            }
            case CREATIVE: 
            case CRAFTING: 
            case MERCHANT: {
                throw new IllegalArgumentException("Can't open a " + String.valueOf(inventory.getType()) + " inventory!");
            }
            case CRAFTER: {
                return MenuType.CRAFTER_3x3;
            }
        }
        return MenuType.GENERIC_9x3;
    }

    private void setupSlots(Container top, net.minecraft.world.entity.player.Inventory bottom, Player entityhuman) {
        int windowId = -1;
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                this.delegate = new ChestMenu(MenuType.GENERIC_9x3, windowId, bottom, top, top.getContainerSize() / 9);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new DispenserMenu(windowId, bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new FurnaceMenu(windowId, bottom, top, new SimpleContainerData(4));
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new EnchantmentMenu(windowId, bottom);
                break;
            }
            case BREWING: {
                this.delegate = new BrewingStandMenu(windowId, bottom, top, new SimpleContainerData(2));
                break;
            }
            case HOPPER: {
                this.delegate = new HopperMenu(windowId, bottom, top);
                break;
            }
            case ANVIL: {
                this.setupAnvil(top, bottom);
                break;
            }
            case BEACON: {
                this.delegate = new BeaconMenu(windowId, bottom);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new ShulkerBoxMenu(windowId, bottom, top);
                break;
            }
            case BLAST_FURNACE: {
                this.delegate = new BlastFurnaceMenu(windowId, bottom, top, new SimpleContainerData(4));
                break;
            }
            case LECTERN: {
                this.delegate = new LecternMenu(windowId, top, new SimpleContainerData(1), bottom);
                break;
            }
            case SMOKER: {
                this.delegate = new SmokerMenu(windowId, bottom, top, new SimpleContainerData(4));
                break;
            }
            case LOOM: {
                this.delegate = new LoomMenu(windowId, bottom);
                break;
            }
            case CARTOGRAPHY: {
                this.delegate = new CartographyTableMenu(windowId, bottom);
                break;
            }
            case GRINDSTONE: {
                this.delegate = new GrindstoneMenu(windowId, bottom);
                break;
            }
            case STONECUTTER: {
                this.delegate = new StonecutterMenu(windowId, bottom);
                break;
            }
            case MERCHANT: {
                this.delegate = new MerchantMenu(windowId, bottom);
                break;
            }
            case SMITHING: 
            case SMITHING_NEW: {
                this.setupSmithing(top, bottom);
                break;
            }
            case CRAFTER: {
                this.delegate = new CrafterMenu(windowId, bottom);
            }
        }
        if (this.delegate != null) {
            this.lastSlots = this.delegate.lastSlots;
            this.slots = this.delegate.slots;
            this.remoteSlots = this.delegate.remoteSlots;
            this.dataSlots = this.delegate.dataSlots;
            this.remoteDataSlots = this.delegate.remoteDataSlots;
        }
        switch (this.cachedType) {
            case WORKBENCH: {
                this.delegate = new CraftingMenu(windowId, bottom);
                break;
            }
            case ANVIL: {
                this.delegate = new AnvilMenu(windowId, bottom);
            }
        }
    }

    private void setupWorkbench(Container top, Container bottom) {
        int col;
        int row;
        this.addSlot(new Slot(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.addSlot(new Slot(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupAnvil(Container top, Container bottom) {
        int row;
        this.addSlot(new Slot(top, 0, 27, 47));
        this.addSlot(new Slot(top, 1, 76, 47));
        this.addSlot(new Slot(top, 2, 134, 47));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.addSlot(new Slot(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupSmithing(Container top, Container bottom) {
        int row;
        this.addSlot(new Slot(top, 0, 8, 48));
        this.addSlot(new Slot(top, 1, 26, 48));
        this.addSlot(new Slot(top, 2, 44, 48));
        this.addSlot(new Slot(top, 3, 98, 48));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.addSlot(new Slot(bottom, row, 8 + row * 18, 142));
        }
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slot) {
        return this.delegate != null ? this.delegate.quickMoveStack(player, slot) : ItemStack.EMPTY;
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public MenuType<?> getType() {
        return CraftContainer.getNotchInventoryType(this.view.getTopInventory());
    }
}

