/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scheduler;

import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerSchedulerException;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.scheduler.CraftAsyncScheduler;
import org.bukkit.craftbukkit.scheduler.CraftAsyncTask;
import org.bukkit.craftbukkit.scheduler.CraftFuture;
import org.bukkit.craftbukkit.scheduler.CraftTask;
import org.bukkit.craftbukkit.scheduler.MinecraftInternalPlugin;
import org.bukkit.event.Event;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;

public class CraftScheduler
implements BukkitScheduler {
    public static Plugin MINECRAFT = new MinecraftInternalPlugin();
    private static final int START_ID = 1;
    private static final IntUnaryOperator INCREMENT_IDS = previous -> {
        if (previous == Integer.MAX_VALUE) {
            return 1;
        }
        return previous + 1;
    };
    private final AtomicInteger ids = new AtomicInteger(1);
    private volatile CraftTask head = new CraftTask();
    private final AtomicReference<CraftTask> tail = new AtomicReference<CraftTask>(this.head);
    final PriorityQueue<CraftTask> pending = new PriorityQueue<CraftTask>(10, new Comparator<CraftTask>(this){

        @Override
        public int compare(CraftTask o1, CraftTask o2) {
            int value = Long.compare(o1.getNextRun(), o2.getNextRun());
            return value != 0 ? value : Long.compare(o1.getCreatedAt(), o2.getCreatedAt());
        }
    });
    private final List<CraftTask> temp = new ArrayList<CraftTask>();
    final ConcurrentHashMap<Integer, CraftTask> runners = new ConcurrentHashMap();
    private volatile CraftTask currentTask = null;
    volatile int currentTick = -1;
    private static final int RECENT_TICKS = 30;
    private final CraftScheduler asyncScheduler;
    private final boolean isAsyncScheduler;

    public CraftScheduler() {
        this(false);
    }

    public CraftScheduler(boolean isAsync) {
        this.isAsyncScheduler = isAsync;
        this.asyncScheduler = isAsync ? this : new CraftAsyncScheduler();
    }

    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task) {
        return this.scheduleSyncDelayedTask(plugin, task, 0L);
    }

    public BukkitTask runTask(Plugin plugin, Runnable runnable) {
        return this.runTaskLater(plugin, runnable, 0L);
    }

    public void runTask(Plugin plugin, Consumer<? super BukkitTask> task) throws IllegalArgumentException {
        this.runTaskLater(plugin, task, 0L);
    }

    @Deprecated
    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task) {
        return this.scheduleAsyncDelayedTask(plugin, task, 0L);
    }

    public BukkitTask runTaskAsynchronously(Plugin plugin, Runnable runnable) {
        return this.runTaskLaterAsynchronously(plugin, runnable, 0L);
    }

    public void runTaskAsynchronously(Plugin plugin, Consumer<? super BukkitTask> task) throws IllegalArgumentException {
        this.runTaskLaterAsynchronously(plugin, task, 0L);
    }

    public int scheduleSyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        return this.scheduleSyncRepeatingTask(plugin, task, delay, -1L);
    }

    public BukkitTask runTaskLater(Plugin plugin, Runnable runnable, long delay) {
        return this.runTaskTimer(plugin, runnable, delay, -1L);
    }

    public void runTaskLater(Plugin plugin, Consumer<? super BukkitTask> task, long delay) throws IllegalArgumentException {
        this.runTaskTimer(plugin, task, delay, -1L);
    }

    @Deprecated
    public int scheduleAsyncDelayedTask(Plugin plugin, Runnable task, long delay) {
        return this.scheduleAsyncRepeatingTask(plugin, task, delay, -1L);
    }

    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, Runnable runnable, long delay) {
        return this.runTaskTimerAsynchronously(plugin, runnable, delay, -1L);
    }

    public void runTaskLaterAsynchronously(Plugin plugin, Consumer<? super BukkitTask> task, long delay) throws IllegalArgumentException {
        this.runTaskTimerAsynchronously(plugin, task, delay, -1L);
    }

    public void runTaskTimerAsynchronously(Plugin plugin, Consumer<? super BukkitTask> task, long delay, long period) throws IllegalArgumentException {
        this.runTaskTimerAsynchronously(plugin, (Object)task, delay, period);
    }

    public int scheduleSyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimer(plugin, runnable, delay, period).getTaskId();
    }

    public BukkitTask runTaskTimer(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimer(plugin, (Object)runnable, delay, period);
    }

    public void runTaskTimer(Plugin plugin, Consumer<? super BukkitTask> task, long delay, long period) throws IllegalArgumentException {
        this.runTaskTimer(plugin, (Object)task, delay, period);
    }

    public BukkitTask scheduleInternalTask(Runnable run, int delay, String taskName) {
        CraftTask task = new CraftTask(run, this.nextId(), "Internal - " + (taskName != null ? taskName : "Unknown"));
        task.internal = true;
        return this.handle(task, delay);
    }

    public BukkitTask runTaskTimer(Plugin plugin, Object runnable, long delay, long period) {
        CraftScheduler.validate(plugin, runnable);
        if (delay < 0L) {
            delay = 0L;
        }
        if (period == 0L) {
            period = 1L;
        } else if (period < -1L) {
            period = -1L;
        }
        return this.handle(new CraftTask(plugin, runnable, this.nextId(), period), delay);
    }

    @Deprecated
    public int scheduleAsyncRepeatingTask(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, runnable, delay, period).getTaskId();
    }

    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, Runnable runnable, long delay, long period) {
        return this.runTaskTimerAsynchronously(plugin, (Object)runnable, delay, period);
    }

    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, Object runnable, long delay, long period) {
        CraftScheduler.validate(plugin, runnable);
        if (delay < 0L) {
            delay = 0L;
        }
        if (period == 0L) {
            period = 1L;
        } else if (period < -1L) {
            period = -1L;
        }
        return this.handle(new CraftAsyncTask(this.asyncScheduler.runners, plugin, runnable, this.nextId(), period), delay);
    }

    public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> task) {
        CraftScheduler.validate(plugin, task);
        CraftFuture<T> future = new CraftFuture<T>(task, plugin, this.nextId());
        this.handle(future, 0L);
        return future;
    }

    public void cancelTask(final int taskId) {
        CraftTask task;
        if (taskId <= 0) {
            return;
        }
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.cancelTask(taskId);
        }
        if ((task = this.runners.get(taskId)) != null) {
            task.cancel0();
        }
        task = new CraftTask(new Runnable(){

            @Override
            public void run() {
                if (!this.check(CraftScheduler.this.temp)) {
                    this.check(CraftScheduler.this.pending);
                }
            }

            private boolean check(Iterable<CraftTask> collection) {
                Iterator<CraftTask> tasks = collection.iterator();
                while (tasks.hasNext()) {
                    CraftTask task = tasks.next();
                    if (task.getTaskId() != taskId) continue;
                    task.cancel0();
                    tasks.remove();
                    if (task.isSync()) {
                        CraftScheduler.this.runners.remove(taskId);
                    }
                    return true;
                }
                return false;
            }
        });
        this.handle(task, 0L);
        for (CraftTask taskPending = this.head.getNext(); taskPending != null; taskPending = taskPending.getNext()) {
            if (taskPending == task) {
                return;
            }
            if (taskPending.getTaskId() != taskId) continue;
            taskPending.cancel0();
        }
    }

    public void cancelTasks(final Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Cannot cancel tasks of null plugin");
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.cancelTasks(plugin);
        }
        CraftTask task = new CraftTask(new Runnable(){

            @Override
            public void run() {
                this.check(CraftScheduler.this.pending);
                this.check(CraftScheduler.this.temp);
            }

            void check(Iterable<CraftTask> collection) {
                Iterator<CraftTask> tasks = collection.iterator();
                while (tasks.hasNext()) {
                    CraftTask task = tasks.next();
                    if (!task.getOwner().equals((Object)plugin)) continue;
                    task.cancel0();
                    tasks.remove();
                    if (!task.isSync()) continue;
                    CraftScheduler.this.runners.remove(task.getTaskId());
                }
            }
        });
        this.handle(task, 0L);
        for (CraftTask taskPending = this.head.getNext(); taskPending != null && taskPending != task; taskPending = taskPending.getNext()) {
            if (taskPending.getTaskId() == -1 || !taskPending.getOwner().equals((Object)plugin)) continue;
            taskPending.cancel0();
        }
        for (CraftTask runner : this.runners.values()) {
            if (!runner.getOwner().equals((Object)plugin)) continue;
            runner.cancel0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentlyRunning(int taskId) {
        if (!this.isAsyncScheduler && this.asyncScheduler.isCurrentlyRunning(taskId)) {
            return true;
        }
        CraftTask task = this.runners.get(taskId);
        if (task == null) {
            return false;
        }
        if (task.isSync()) {
            return task == this.currentTask;
        }
        CraftAsyncTask asyncTask = (CraftAsyncTask)task;
        LinkedList<BukkitWorker> linkedList = asyncTask.getWorkers();
        synchronized (linkedList) {
            return !asyncTask.getWorkers().isEmpty();
        }
    }

    public boolean isQueued(int taskId) {
        CraftTask task;
        if (taskId <= 0) {
            return false;
        }
        if (!this.isAsyncScheduler && this.asyncScheduler.isQueued(taskId)) {
            return true;
        }
        for (task = this.head.getNext(); task != null; task = task.getNext()) {
            if (task.getTaskId() != taskId) continue;
            return task.getPeriod() >= -1L;
        }
        task = this.runners.get(taskId);
        return task != null && task.getPeriod() >= -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BukkitWorker> getActiveWorkers() {
        if (!this.isAsyncScheduler) {
            return this.asyncScheduler.getActiveWorkers();
        }
        ArrayList<BukkitWorker> workers = new ArrayList<BukkitWorker>();
        for (CraftTask taskObj : this.runners.values()) {
            if (taskObj.isSync()) continue;
            CraftAsyncTask task = (CraftAsyncTask)taskObj;
            LinkedList<BukkitWorker> linkedList = task.getWorkers();
            synchronized (linkedList) {
                workers.addAll(task.getWorkers());
            }
        }
        return workers;
    }

    public List<BukkitTask> getPendingTasks() {
        ArrayList<CraftTask> truePending = new ArrayList<CraftTask>();
        for (CraftTask task = this.head.getNext(); task != null; task = task.getNext()) {
            if (task.getTaskId() == -1) continue;
            truePending.add(task);
        }
        ArrayList<BukkitTask> pending = new ArrayList<BukkitTask>();
        for (CraftTask task : this.runners.values()) {
            if (task.getPeriod() < -1L) continue;
            pending.add(task);
        }
        for (CraftTask task : truePending) {
            if (task.getPeriod() < -1L || pending.contains(task)) continue;
            pending.add(task);
        }
        if (!this.isAsyncScheduler) {
            pending.addAll(this.asyncScheduler.getPendingTasks());
        }
        return pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainThreadHeartbeat(int currentTick) {
        if (!this.isAsyncScheduler) {
            this.asyncScheduler.mainThreadHeartbeat(currentTick);
        }
        this.currentTick = currentTick;
        List<CraftTask> temp = this.temp;
        this.parsePending();
        while (this.isReady(currentTick)) {
            CraftTask task = (CraftTask)this.pending.remove();
            if (task.getPeriod() < -1L) {
                if (task.isSync()) {
                    this.runners.remove(task.getTaskId(), task);
                }
                this.parsePending();
                continue;
            }
            if (task.isSync()) {
                this.currentTask = task;
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                    String msg = String.format("Task #%s for %s generated an exception", task.getTaskId(), task.getOwner().getDescription().getFullName());
                    if (task.getOwner() == MINECRAFT) {
                        MinecraftServer.LOGGER.error(msg, throwable);
                    } else {
                        task.getOwner().getLogger().log(Level.WARNING, msg, throwable);
                    }
                    Bukkit.getServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerSchedulerException(msg, throwable, (BukkitTask)task)));
                }
                finally {
                    this.currentTask = null;
                }
                this.parsePending();
            } else {
                task.getOwner().getLogger().log(Level.SEVERE, "Unexpected Async Task in the Sync Scheduler. Report this to Paper");
            }
            long period = task.getPeriod();
            if (period > 0L) {
                task.setNextRun((long)currentTick + period);
                temp.add(task);
                continue;
            }
            if (!task.isSync()) continue;
            this.runners.remove(task.getTaskId());
        }
        this.pending.addAll(temp);
        temp.clear();
    }

    protected void addTask(CraftTask task) {
        AtomicReference<CraftTask> tail = this.tail;
        CraftTask tailTask = tail.get();
        while (!tail.compareAndSet(tailTask, task)) {
            tailTask = tail.get();
        }
        tailTask.setNext(task);
    }

    protected CraftTask handle(CraftTask task, long delay) {
        if (!this.isAsyncScheduler && !task.isSync()) {
            this.asyncScheduler.handle(task, delay);
            return task;
        }
        task.setNextRun((long)this.currentTick + delay);
        this.addTask(task);
        return task;
    }

    private static void validate(Plugin plugin, Object task) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((task instanceof Runnable || task instanceof Consumer || task instanceof Callable ? 1 : 0) != 0, (Object)"Task must be Runnable, Consumer, or Callable");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
    }

    private int nextId() {
        int id;
        Preconditions.checkArgument((this.runners.size() < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"There are already %s tasks scheduled! Cannot schedule more", (int)Integer.MAX_VALUE);
        while (this.runners.containsKey(id = this.ids.updateAndGet(INCREMENT_IDS))) {
        }
        return id;
    }

    void parsePending() {
        CraftTask head = this.head;
        CraftTask task = head.getNext();
        CraftTask lastTask = head;
        while (task != null) {
            if (task.getTaskId() == -1) {
                task.run();
            } else if (task.getPeriod() >= -1L) {
                this.pending.add(task);
                this.runners.put(task.getTaskId(), task);
            }
            lastTask = task;
            task = lastTask.getNext();
        }
        task = head;
        while (task != lastTask) {
            head = task.getNext();
            task.setNext(null);
            task = head;
        }
        this.head = lastTask;
    }

    private boolean isReady(int currentTick) {
        return !this.pending.isEmpty() && this.pending.peek().getNextRun() <= (long)currentTick;
    }

    public String toString() {
        return "";
    }

    @Deprecated
    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task, long delay) {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskLater(Plugin, long)");
    }

    @Deprecated
    public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable task) {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTask(Plugin)");
    }

    @Deprecated
    public int scheduleSyncRepeatingTask(Plugin plugin, BukkitRunnable task, long delay, long period) {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskTimer(Plugin, long, long)");
    }

    @Deprecated
    public BukkitTask runTask(Plugin plugin, BukkitRunnable task) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTask(Plugin)");
    }

    @Deprecated
    public BukkitTask runTaskAsynchronously(Plugin plugin, BukkitRunnable task) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskAsynchronously(Plugin)");
    }

    @Deprecated
    public BukkitTask runTaskLater(Plugin plugin, BukkitRunnable task, long delay) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskLater(Plugin, long)");
    }

    @Deprecated
    public BukkitTask runTaskLaterAsynchronously(Plugin plugin, BukkitRunnable task, long delay) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskLaterAsynchronously(Plugin, long)");
    }

    @Deprecated
    public BukkitTask runTaskTimer(Plugin plugin, BukkitRunnable task, long delay, long period) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskTimer(Plugin, long, long)");
    }

    @Deprecated
    public BukkitTask runTaskTimerAsynchronously(Plugin plugin, BukkitRunnable task, long delay, long period) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Use BukkitRunnable#runTaskTimerAsynchronously(Plugin, long, long)");
    }

    public Executor getMainThreadExecutor(Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        return command -> {
            Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"Command cannot be null");
            this.runTask(plugin, command);
        };
    }
}

