/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import org.leavesmc.leaves.bot.ServerBot;

public class BotInventoryContainer
extends SimpleContainer {
    public final NonNullList<ItemStack> items;
    public final NonNullList<ItemStack> armor;
    public final NonNullList<ItemStack> offhand;
    private final List<NonNullList<ItemStack>> compartments;
    private final NonNullList<ItemStack> buttons = NonNullList.withSize(13, ItemStack.EMPTY);
    private final ServerBot player;

    public BotInventoryContainer(ServerBot player) {
        super(new ItemStack[0]);
        this.player = player;
        this.items = this.player.getInventory().items;
        this.armor = this.player.getInventory().armor;
        this.offhand = this.player.getInventory().offhand;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand, this.buttons);
        this.createButton();
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + this.armor.size() + this.offhand.size() + this.buttons.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemStack : this.armor) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemStack : this.offhand) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public ItemStack getItem(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        if (pair != null) {
            return (ItemStack)((NonNullList)pair.getFirst()).get((Integer)pair.getSecond());
        }
        return ItemStack.EMPTY;
    }

    public Pair<NonNullList<ItemStack>, Integer> getItemSlot(int slot) {
        switch (slot) {
            case 0: {
                return new Pair(this.buttons, (Object)0);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Pair(this.armor, (Object)(4 - slot));
            }
            case 5: 
            case 6: {
                return new Pair(this.buttons, (Object)(slot - 4));
            }
            case 7: {
                return new Pair(this.offhand, (Object)0);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return new Pair(this.buttons, (Object)(slot - 5));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return new Pair(this.items, (Object)(slot - 9));
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new Pair(this.items, (Object)(slot - 45));
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public ItemStack removeItem(int slot, int amount) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        ItemStack itemStack = ItemStack.EMPTY;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).isEmpty()) {
            itemStack = ContainerHelper.removeItem(list, slot, amount);
            this.player.detectEquipmentUpdatesPublic();
        }
        return itemStack;
    }

    @Override
    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).isEmpty()) {
            ItemStack itemStack = (ItemStack)list.get(slot);
            list.set(slot, ItemStack.EMPTY);
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int slot, @Nonnull ItemStack stack) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null) {
            list.set(slot, stack);
            this.player.detectEquipmentUpdatesPublic();
        }
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        if (this.player.isRemoved()) {
            return false;
        }
        return !(player.distanceToSqr(this.player) > 64.0);
    }

    @Override
    public void clearContent() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    private void createButton() {
        CompoundTag customData = new CompoundTag();
        customData.putBoolean("Leaves.Gui.Placeholder", true);
        DataComponentPatch patch = DataComponentPatch.builder().set(DataComponents.CUSTOM_NAME, Component.empty()).set(DataComponents.CUSTOM_DATA, CustomData.of(customData)).build();
        for (int i = 0; i < 13; ++i) {
            ItemStack button = new ItemStack(Items.STRUCTURE_VOID);
            button.applyComponents(patch);
            this.buttons.set(i, button);
        }
    }
}

